import logging
import traceback
from functools import wraps

from typing import Callable, Any


def _try_except_silent() -> Callable:
    def decorate(func: Callable) -> Callable:

        @wraps(func)
        def wrapper(*args, **kwargs) -> Any:
            try:
                return func(*args, **kwargs)
            except (Exception,):
                logging.debug(traceback.format_exc())

        return wrapper

    return decorate
