"""
Модуль пользовательского интерфейса.

В данном модуле содержатся классы связанные с пользовательским интерфейсом.
"""

# depends on axipy.da, axipy.cs, axipy.utl, axipy.render, [axipy.app]

from .notifications import *  # no dependencies
from .gui_class import *  # no dependencies
from .action_manager import *  # depends on gui_class
from .active_tool_panel import *  # depends on axipy.da, gui_class
from .selection_manager_ import *  # depends on axipy.da, gui_class
from .dialog import *  # depends on axipy.da, axipy.cs
from .view import *  # depends on axipy.da, axipy.cs, axipy.render, axipy.utl
from .map_tool import *  # depends on view, axipy.da, axipy.utl
from .view_manager_ import *  # depends on gui_class, view, axipy.da, axipy.render, axipy.app
from .widgets import *  # depends on gui_class, view, view_manager_, axipy.da
from .workspace import *  # depends on gui_class

DialogWrapper = dialog
SelectionManagerWrapper = selection_manager_
ToolWrapper = map_tool
view_manager_wrapper = view_manager_
ViewWrapper = view
WidgetWrapper = widgets


def __getattr__(name: str):
    """
    Backwards compatibility.
    """
    old_names = {
        "ActiveToolPanel": active_tool_panel,
        "DialogWrapper": dialog,
        "SelectionManagerWrapper": selection_manager_,
        "ToolWrapper": map_tool,
        "view_manager_wrapper": view_manager_,
        "ViewWrapper": view,
        "WidgetWrapper": widgets,
        "Workspace": workspace,
    }
    if name in old_names:
        return old_names[name]

    raise AttributeError(f"module {__name__!r} has no attribute {name!r}")


"""
Attributes:
    view_manager (ViewManager): Экземпляр менеджера содержимого окон.
    selection_manager (SelectionManager): Экземпляр доступа к выделенным объектам.
"""
