import axipy.cpp_app
import axipy.cpp_core_core
import axipy.cpp_cs
import axipy.cpp_gui
import axipy.cpp_render
# from axipy.cpp_core_core import ShadowIO
# from axipy.cpp_core_dp import ShadowDataCatalog
from typing import Optional


# class _ShadowFactory:
#
#     def __init__(self) -> None:
#         self._shadow_io: Optional[ShadowIO] = None
#         self._shadow_data_catalog: Optional[ShadowDataCatalog] = None
#
#     @property
#     def shadow_io(self) -> ShadowIO:
#         if self._shadow_io is None:
#             self._shadow_io = ShadowIO(_shadow_manager.core)
#             self._shadow_io.setDefaultCatalog(_shadow_manager.gui.catalog())
#         return self._shadow_io
#
#     @property
#     def shadow_data_catalog(self) -> ShadowDataCatalog:
#         if self._shadow_data_catalog is None:
#             self._shadow_data_catalog = _shadow_manager.gui.catalog()
#         return self._shadow_data_catalog
#
#
# _shadow_factory = _ShadowFactory()


class _ShadowManager:
    _error_msg_axipy_init = "axipy is not initialized"
    _error_msg_main_window = "main_window instance hasn't created yet."

    def __init__(self) -> None:
        self._cs_factory: Optional[axipy.cpp_cs.ShadowCoordSysFactory] = None
        self._core: Optional[axipy.cpp_core_core.Core] = None
        self._render: Optional[axipy.cpp_render.Render] = None
        self._gui: Optional[axipy.cpp_gui.ShadowGui] = None
        self._state_observer: Optional[axipy.cpp_core_core.StateObserver] = None

        self._main_window: Optional[axipy.cpp_app.ShadowMainWindow] = None

    @property
    def cs_factory(self) -> axipy.cpp_cs.ShadowCoordSysFactory:
        if self._cs_factory is None:
            raise RuntimeError(self._error_msg_axipy_init)
        return self._cs_factory

    @cs_factory.setter
    def cs_factory(self, value: axipy.cpp_cs.ShadowCoordSysFactory) -> None:
        self._cs_factory = value

    @property
    def core(self) -> axipy.cpp_core_core.Core:
        if self._core is None:
            raise RuntimeError(self._error_msg_axipy_init)
        return self._core

    @core.setter
    def core(self, value: axipy.cpp_core_core.Core) -> None:
        self._core = value

    @property
    def render(self) -> axipy.cpp_render.Render:
        if self._render is None:
            raise RuntimeError(self._error_msg_axipy_init)
        return self._render

    @render.setter
    def render(self, value: axipy.cpp_render.Render) -> None:
        self._render = value

    @property
    def gui(self) -> axipy.cpp_gui.ShadowGui:
        if self._gui is None:
            raise RuntimeError(self._error_msg_axipy_init)
        return self._gui

    @gui.setter
    def gui(self, value: axipy.cpp_gui.ShadowGui) -> None:
        self._gui = value

    @property
    def state_observer(self) -> axipy.cpp_core_core.StateObserver:
        if self._state_observer is None:
            raise RuntimeError(self._error_msg_axipy_init)
        return self._state_observer

    @state_observer.setter
    def state_observer(self, value: axipy.cpp_core_core.StateObserver) -> None:
        self._state_observer = value

    @property
    def main_window(self) -> axipy.cpp_app.ShadowMainWindow:
        if self._main_window is None:
            raise RuntimeError(self._error_msg_main_window)
        return self._main_window

    @main_window.setter
    def main_window(self, value: axipy.cpp_app.ShadowMainWindow) -> None:
        self._main_window = value

    # noinspection PyStatementEffect
    def ensure_axioma_is_initialized(self) -> None:
        self.cs_factory
        self.core
        self.render
        self.gui
        self.state_observer


_shadow_manager: _ShadowManager = _ShadowManager()
