import axipy
import warnings
from ._deprecated import _apply_deprecated


def _apply_all() -> None:
    _apply_deprecated()

    # Включение вывода DeprecationWarning т.к. по умолчанию они отключены.
    warnings.simplefilter("default")

    def __getattr__(name: str):
        """
        Backwards compatibility.
        """
        old_names = {
            # da
            "attribute_schema": axipy.schema,
            "DataManagerWrapper": axipy.data_manager_,
            # gui
            "ActiveToolPanel": axipy.active_tool_panel,
            "DialogWrapper": axipy.dialog,
            "Notifications": axipy.notifications,
            "SelectionManagerWrapper": axipy.selection_manager_,
            "ToolWrapper": axipy.map_tool,
            "view_manager_wrapper": axipy.view_manager_,
            "ViewWrapper": axipy.view,
            "WidgetWrapper": axipy.widgets,
            "Workspace": axipy.workspace,
            # mi
            "MIGeometry": axipy.mi_geometry,
        }
        if name in old_names:
            return old_names[name]

        raise AttributeError(f"module axipy has no attribute {name!r}")

    setattr(axipy, "__getattr__", __getattr__)
