"""
Основной пакет API для взаимодействия с ГИС Аксиома.

Предоставляет доступ к Аксиоме.ГИС через набор модулей, подмодулей, классов и функций.
"""

from .settings import *  # no dependencies
from .concurrent import *  # no dependencies
from .core import *  # no dependencies
from .sql import *  # no dependencies
from .utl import *  # no dependencies
from .cs import *  # no dependencies
from .da import *  # depends on axipy.cs, axipy.utl
from .render import *  # depends on axipy.da, axipy.cs, axipy.utl
from .gui import *  # depends on axipy.da, axipy.cs, axipy.utl, axipy.render, [axipy.app]
from .initialization import *  # depends on axipy.da, axipy.gui
from .app import *  # depends on axipy.da, axipy.gui, axipy.render
from .mi import *  # depends on axipy.da, axipy.gui, axipy.cs, axipy.utl
from .interface import *  # depends on axipy.da, axipy.gui
from .menubar import *  # depends on axipy.da, axipy.gui
from .axioma_plugin import *  # depends on interface, axipy.da, axipy.gui, axipy.menubar
from .plugin import *  # depends on axipy.app, axipy.da, axipy.gui, axipy.menubar
from .utils import *  # depends on axioma_plugin, settings, axipy.app

from ._internal import _apply_all

_apply_all()
