"""Модуль классов, относящихся к MapInfo."""

# depends on axipy.da, axipy.gui, axipy.cs, axipy.utl

from .mi_geometry import *  # depends on axipy.da, axipy.gui, axipy.cs, axipy.utl

MIGeometry = mi_geometry


def __getattr__(name: str):
    """
    Backwards compatibility.
    """
    old_names = {
        "MIGeometry": mi_geometry,
    }
    if name in old_names:
        return old_names[name]

    raise AttributeError(f"module {__name__!r} has no attribute {name!r}")
