"""
Точка входа в модуль.
"""
from axipy import Position, tr, Plugin, view_manager, CurrentSettings

import traceback
import uuid
from PySide2.QtWidgets import QMessageBox
from osgeo import gdal
from .helper import clear_data_dir
from .wizardconverter import WizardConverter


class VectorConverter(Plugin):

    def __init__(self) -> None:
        self._action = self.create_action(
            title=tr("Конвертер"),
            on_click=self.show_plugin_window,
            icon=str(self.plugin_dir / "icon" / "Translate-01.png"),
            tooltip=tr("Конвертер векторных форматов"),
            doc_file="index.html"
        )

        position = Position(tr("Основные"), tr("Команды"))
        position.add(self._action)

        self._plugin_window = None

        self._uuid = uuid.uuid4().hex  # type: str

        clear_data_dir(self.get_plugin_data_dir())

    def unload(self) -> None:
        self._action.remove()

        self._plugin_window = None

    def show_plugin_window(self) -> None:
        """
        Функция показа окна плагина.
        """

        if self._plugin_window is None:
            success = self.init_plugin_window()
            if not success:
                return None

        # Запомнить состояние режима исключений gdal при показе окна
        self._plugin_window.use_exceptions = gdal.GetUseExceptions()
        self._plugin_window.show()

    def init_plugin_window(self) -> bool:
        """
        Создание окна плагина.
        """
        try:
            self._plugin_window = WizardConverter(
                view_manager.global_parent, CurrentSettings.Language, self.get_plugin_data_dir() / self._uuid)
        except (Exception,):
            traceback.print_exc()

            m_box = QMessageBox(
                QMessageBox.Warning,  # icon
                tr("Ошибка"),  # title
                tr("Не удалось создать окно Помощника."),  # text
                buttons=QMessageBox.Ok,
                parent=view_manager.global_parent,
            )
            m_box.exec_()

            self._plugin_window = None
            return False
        else:
            return True
