from axipy import ActionButton, Position, Plugin, view_manager

from PySide2.QtGui import QIcon
from typing import Optional
from .qdialog_main import QDialogMain


class ExportToDatabase(Plugin):

    def __init__(self) -> None:
        self._dialog: Optional[QDialogMain] = None
        self._button = ActionButton(
            title=self.tr("Экспорт в БД"),
            on_click=self.on_click,
            icon=QIcon.fromTheme("export_to_db"),
        )
        position = Position(self.tr("Основные"), self.tr("Команды"))
        position.add(self._button)

    def unload(self) -> None:
        self._button.remove()

        if self._dialog is not None:
            self._dialog.deleteLater()
            self._dialog = None

    def on_click(self) -> None:
        if self._dialog is None:
            self._dialog = QDialogMain(self, parent=view_manager.global_parent)
        self._dialog.open()
