from os import listdir
from os.path import join, isdir
from pathlib import Path

from typing import Union

from .parser import IParser, MANIFEST_FILE_NAME


class FolderParser(IParser):
    def parse(self, location_path: Union[str, Path]) -> dict:
        manifest_filepath = join(location_path, MANIFEST_FILE_NAME)
        with open(manifest_filepath, encoding='utf-8') as manifest_file:
            result = self.read_config(manifest_file)
        doc_dir = join(location_path, 'documentation')
        if isdir(doc_dir):
            def is_doc_entry(filename: str):
                return filename.startswith('index') and filename.endswith('html')

            doc_entry_points = filter(is_doc_entry, listdir(doc_dir))
            result['documentation'] = [join(doc_dir, entry) for entry in doc_entry_points]
        return result

    @staticmethod
    def supports(location_path: Union[str, Path]) -> bool:
        return True
