"""
Модуль для работы с длительными пользовательскими задачами, выполняемыми в фоновом потоке.
"""

# no dependencies

from .axipy_progress_handler import *  # no dependencies
from .task import *  # depends on axipy_progress_handler
from .task_utils import *  # no dependencies
from .task_manager_ import *  # depends on task, task_utils

# AxipyProgressHandler = axipy_progress_handler  # overridden by class AxipyProgressHandler
Task = task
# TaskManager = task_manager_  # overridden by class TaskManager
TaskUtils = task_utils


def __getattr__(name: str):
    """
    Backwards compatibility.
    """
    old_names = {
        "AxipyProgressHandler": axipy_progress_handler,
        "Task": task,
        "TaskManager": task_manager_,
        "TaskUtils": task_utils,
    }
    if name in old_names:
        return old_names[name]

    raise AttributeError(f"module {__name__!r} has no attribute {name!r}")


"""
Attributes:
    task_manager (TaskManager): Экземпляр менеджера запускающего пользовательские задачи.
"""
