import os

from PySide2.QtCore import Qt, QFileInfo
from PySide2.QtUiTools import QUiLoader
from PySide2.QtWidgets import QDialog, QFileDialog, QDialogButtonBox

from axipy import view_manager, data_manager, Settings, Plugin, mainwindow


class SavePointsDialog(QDialog):

    def __init__(self, iface: Plugin) -> None:
        super().__init__(mainwindow.qt_object())
        self._tr = iface.tr
        ui_file = os.path.join(os.path.dirname(__file__), "SavePointsDialog.ui")
        self._ui = QUiLoader().load(ui_file, self)
        self._file_name = None
        self._load_ui()
        self._ui.setParent(view_manager.global_parent)
        self._ui.setWindowFlags(self.windowFlags() & ~Qt.WindowContextHelpButtonHint)

    def _load_ui(self):
        for t in data_manager.tables:
            self._ui.cbTables.addItem(t.name)
        self._ui.buttonBox.button(QDialogButtonBox.Ok).setEnabled(self._ui.cbTables.count())

    def _select_file(self):
        dlg = QFileDialog(self)
        dlg.setNameFilter(self._tr("Таблицы Excel (*.xlsx);;CSV файлы (*.csv);;MapInfo TAB (*.tab)"))
        dlg.setFileMode(QFileDialog.AnyFile)
        dlg.setDirectory(Settings.value(Settings.LastSavePath))
        dlg.setAcceptMode(QFileDialog.AcceptSave)
        dlg.setDefaultSuffix("tab")
        if dlg.exec() == QDialog.Accepted:
            if not len(dlg.selectedFiles()):
                return None
            file_name = dlg.selectedFiles()[0]
            if len(QFileInfo(file_name).suffix()) == 0:
                file_name += ".tab"
            Settings.setValue(Settings.LastSavePath, os.path.dirname(file_name))
            return file_name
        return None

    def result_file_name(self):
        return self._file_name

    def result_table(self):
        # Результирующая базовая таблица
        return data_manager.find(self._ui.cbTables.currentText())

    def result_format_data_index(self):
        return self._ui.cbFormatData.currentIndex()

    def result_type_coordinates_index(self):
        return self._ui.cbTypeData.currentIndex()

    def accept(self):
        super().accept()

    def exec(self):
        res = self._ui.exec()
        if res == QDialog.Accepted:
            self._file_name = self._select_file()
        return QDialog.Accepted if res == QDialog.Accepted and self._file_name is not None else QDialog.Rejected
