from typing import Any, Optional


class _Desc:
    """
    Шаблон дескриптора.
    """
    def __init__(self) -> None:
        self._inst = None
        self._name: Optional[str] = None

    def __set_name__(self, owner, name: str) -> None:
        self._name = name

    def __get__(self, obj, objtype=None):
        if self._inst is not None:
            return self._inst


_NoInitTypeError = TypeError("Class doesn't support init")


class _ReadOnlyMeta(type):

    def __setattr__(cls, key: str, value: Any) -> None:
        raise TypeError("Class is read-only")


class _NoInit:

    def __init__(self) -> None:
        raise _NoInitTypeError


class _NoInitReadOnlyMeta(_NoInit, metaclass=_ReadOnlyMeta):
    ...


class _MappingRepr:

    def __repr__(self):
        return repr(self.items())

    def keys(self):
        return list(super().keys())

    def values(self):
        return list(super().values())

    def items(self):
        return list(super().items())
