import axipy
from axipy._internal._decorator import _deprecated_by
from axipy._internal._shadow_instance_factory import _ShadowManager
from typing import Type


def _MainWindow_apply_deprecated(class_type: Type) -> Type:
    # hide deprecated methods from IntelliSense

    @_deprecated_by("axipy.Workspace.load_file")
    def load_workspace(self, fileName: str) -> None:
        """
        Читает рабочее пространство из файла.

        Args:
            self:
            fileName: Наименование входного файла.

        :meta private:
        """
        self.service().open_workspace(fileName)

    setattr(class_type, "load_workspace", load_workspace)

    @_deprecated_by("axipy.Workspace.save_file")
    def save_workspace(self, fileName: str) -> None:
        """Сохраняет рабочее пространство в файл.

        Args:
            self:
            fileName: Наименование выходного файла.

        :meta private:
        """

        self.service().save_workspace(fileName)

    setattr(class_type, "save_workspace", save_workspace)

    return class_type


def _apply_deprecated_methods() -> None:

    @property
    @_deprecated_by("axipy.CurrentSettings.Language")
    def language(self) -> str:
        """
        Значение языка, с которым запущено приложение. Например, ``'ru'``.

        :meta private:
        """
        return _ShadowManager.core.translationLanguage()

    setattr(axipy.Plugin, "language", language)
