from typing import overload
import PySide2.QtCore
import shiboken2
import typing
T = typing.TypeVar('T')

class QAbstractItemModelReplica(PySide2.QtCore.QAbstractItemModel):
    initialized: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def availableRoles(self) -> typing.List[int]: ...
    def columnCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...
    def data(self, index: PySide2.QtCore.QModelIndex, role: PySide2.QtCore.Qt.ItemDataRole = ...) -> typing.Any: ...
    def flags(self, index: PySide2.QtCore.QModelIndex) -> typing.Union[PySide2.QtCore.Qt.ItemFlags,PySide2.QtCore.Qt.ItemFlag]: ...
    def hasChildren(self, parent: PySide2.QtCore.QModelIndex = ...) -> bool: ...
    def hasData(self, index: PySide2.QtCore.QModelIndex, role: PySide2.QtCore.Qt.ItemDataRole) -> bool: ...
    def headerData(self, section: int, orientation: PySide2.QtCore.Qt.Orientation, role: PySide2.QtCore.Qt.ItemDataRole) -> typing.Any: ...
    def index(self, row: int, column: int, parent: PySide2.QtCore.QModelIndex = ...) -> PySide2.QtCore.QModelIndex: ...
    def isInitialized(self) -> bool: ...
    @overload
    def parent(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    @overload
    def parent(self) -> PySide2.QtCore.QObject: ...
    def roleNames(self) -> typing.Dict[int,PySide2.QtCore.QByteArray]: ...
    def rowCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...
    def selectionModel(self) -> PySide2.QtCore.QItemSelectionModel: ...
    def setData(self, index: PySide2.QtCore.QModelIndex, value: typing.Any, role: PySide2.QtCore.Qt.ItemDataRole = ...) -> bool: ...

class QRemoteObjectAbstractPersistedStore(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def restoreProperties(self, repName: str, repSig: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> typing.List[typing.Any]: ...
    def saveProperties(self, repName: str, repSig: typing.Union[PySide2.QtCore.QByteArray,bytes], values: typing.Iterable[typing.Any]) -> None: ...

class QRemoteObjectDynamicReplica(QRemoteObjectReplica):
    initialized: typing.ClassVar[PySide2.QtCore.Signal] = ...
    notified: typing.ClassVar[PySide2.QtCore.Signal] = ...
    stateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...

class QRemoteObjectHost(QRemoteObjectHostBase):
    hostUrlChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, address: PySide2.QtCore.QUrl, registryAddress: PySide2.QtCore.QUrl = ..., allowedSchemas: QRemoteObjectHostBase.AllowedSchemas = ..., parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., error: typing.Callable = ..., heartbeatInterval: int = ..., heartbeatIntervalChanged: typing.Callable = ..., hostUrl: PySide2.QtCore.QUrl = ..., hostUrlChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., persistedStore: typing.Any = ..., registryUrl: PySide2.QtCore.QUrl = ..., remoteObjectAdded: typing.Callable = ..., remoteObjectRemoved: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, address: PySide2.QtCore.QUrl, parent: typing.Union[PySide2.QtCore.QObject,None], destroyed: typing.Callable = ..., error: typing.Callable = ..., heartbeatInterval: int = ..., heartbeatIntervalChanged: typing.Callable = ..., hostUrl: PySide2.QtCore.QUrl = ..., hostUrlChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., persistedStore: typing.Any = ..., registryUrl: PySide2.QtCore.QUrl = ..., remoteObjectAdded: typing.Callable = ..., remoteObjectRemoved: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., error: typing.Callable = ..., heartbeatInterval: int = ..., heartbeatIntervalChanged: typing.Callable = ..., hostUrl: PySide2.QtCore.QUrl = ..., hostUrlChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., persistedStore: typing.Any = ..., registryUrl: PySide2.QtCore.QUrl = ..., remoteObjectAdded: typing.Callable = ..., remoteObjectRemoved: typing.Callable = ...) -> None: ...
    def hostUrl(self) -> PySide2.QtCore.QUrl: ...
    def setHostUrl(self, hostAddress: PySide2.QtCore.QUrl, allowedSchemas: QRemoteObjectHostBase.AllowedSchemas = ...) -> bool: ...

class QRemoteObjectHostBase(QRemoteObjectNode):
    class AllowedSchemas:
        AllowExternalRegistration: typing.ClassVar[QRemoteObjectHostBase.AllowedSchemas] = ...
        BuiltInSchemasOnly: typing.ClassVar[QRemoteObjectHostBase.AllowedSchemas] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QRemoteObjectHostBase.AllowedSchemas: ...
        def __and__(self, other: typing.SupportsInt) -> QRemoteObjectHostBase.AllowedSchemas: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QRemoteObjectHostBase.AllowedSchemas: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QRemoteObjectHostBase.AllowedSchemas: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QRemoteObjectHostBase.AllowedSchemas: ...
        def __rand__(self, other: typing.SupportsInt) -> QRemoteObjectHostBase.AllowedSchemas: ...
        def __rmul__(self, other: typing.SupportsInt) -> QRemoteObjectHostBase.AllowedSchemas: ...
        def __ror__(self, other: typing.SupportsInt) -> QRemoteObjectHostBase.AllowedSchemas: ...
        def __rsub__(self, other: typing.SupportsInt) -> QRemoteObjectHostBase.AllowedSchemas: ...
        def __rxor__(self, other: typing.SupportsInt) -> QRemoteObjectHostBase.AllowedSchemas: ...
        def __sub__(self, other: typing.SupportsInt) -> QRemoteObjectHostBase.AllowedSchemas: ...
        def __xor__(self, other: typing.SupportsInt) -> QRemoteObjectHostBase.AllowedSchemas: ...
    AllowExternalRegistration: typing.ClassVar[QRemoteObjectHostBase.AllowedSchemas] = ...
    BuiltInSchemasOnly: typing.ClassVar[QRemoteObjectHostBase.AllowedSchemas] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def addHostSideConnection(self, ioDevice: PySide2.QtCore.QIODevice) -> None: ...
    def disableRemoting(self, remoteObject: PySide2.QtCore.QObject) -> bool: ...
    @overload
    def enableRemoting(self, model: PySide2.QtCore.QAbstractItemModel, name: str, roles: typing.List[int], selectionModel: typing.Union[PySide2.QtCore.QItemSelectionModel,None] = ...) -> bool: ...
    @overload
    def enableRemoting(self, object: PySide2.QtCore.QObject, name: str = ...) -> bool: ...
    def hostUrl(self) -> PySide2.QtCore.QUrl: ...
    def proxy(self, registryUrl: PySide2.QtCore.QUrl, hostUrl: PySide2.QtCore.QUrl = ...) -> bool: ...
    def reverseProxy(self) -> bool: ...
    def setHostUrl(self, hostAddress: PySide2.QtCore.QUrl, allowedSchemas: QRemoteObjectHostBase.AllowedSchemas = ...) -> bool: ...
    def setName(self, name: str) -> None: ...

class QRemoteObjectNode(PySide2.QtCore.QObject):
    class ErrorCode:
        HostUrlInvalid: typing.ClassVar[QRemoteObjectNode.ErrorCode] = ...
        ListenFailed: typing.ClassVar[QRemoteObjectNode.ErrorCode] = ...
        MissingObjectName: typing.ClassVar[QRemoteObjectNode.ErrorCode] = ...
        NoError: typing.ClassVar[QRemoteObjectNode.ErrorCode] = ...
        NodeIsNoServer: typing.ClassVar[QRemoteObjectNode.ErrorCode] = ...
        OperationNotValidOnClientNode: typing.ClassVar[QRemoteObjectNode.ErrorCode] = ...
        ProtocolMismatch: typing.ClassVar[QRemoteObjectNode.ErrorCode] = ...
        RegistryAlreadyHosted: typing.ClassVar[QRemoteObjectNode.ErrorCode] = ...
        RegistryNotAcquired: typing.ClassVar[QRemoteObjectNode.ErrorCode] = ...
        ServerAlreadyCreated: typing.ClassVar[QRemoteObjectNode.ErrorCode] = ...
        SourceNotRegistered: typing.ClassVar[QRemoteObjectNode.ErrorCode] = ...
        UnintendedRegistryHosting: typing.ClassVar[QRemoteObjectNode.ErrorCode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QRemoteObjectNode.ErrorCode: ...
        def __and__(self, other: typing.SupportsInt) -> QRemoteObjectNode.ErrorCode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QRemoteObjectNode.ErrorCode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QRemoteObjectNode.ErrorCode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QRemoteObjectNode.ErrorCode: ...
        def __rand__(self, other: typing.SupportsInt) -> QRemoteObjectNode.ErrorCode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QRemoteObjectNode.ErrorCode: ...
        def __ror__(self, other: typing.SupportsInt) -> QRemoteObjectNode.ErrorCode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QRemoteObjectNode.ErrorCode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QRemoteObjectNode.ErrorCode: ...
        def __sub__(self, other: typing.SupportsInt) -> QRemoteObjectNode.ErrorCode: ...
        def __xor__(self, other: typing.SupportsInt) -> QRemoteObjectNode.ErrorCode: ...
    HostUrlInvalid: typing.ClassVar[QRemoteObjectNode.ErrorCode] = ...
    ListenFailed: typing.ClassVar[QRemoteObjectNode.ErrorCode] = ...
    MissingObjectName: typing.ClassVar[QRemoteObjectNode.ErrorCode] = ...
    NoError: typing.ClassVar[QRemoteObjectNode.ErrorCode] = ...
    NodeIsNoServer: typing.ClassVar[QRemoteObjectNode.ErrorCode] = ...
    OperationNotValidOnClientNode: typing.ClassVar[QRemoteObjectNode.ErrorCode] = ...
    ProtocolMismatch: typing.ClassVar[QRemoteObjectNode.ErrorCode] = ...
    RegistryAlreadyHosted: typing.ClassVar[QRemoteObjectNode.ErrorCode] = ...
    RegistryNotAcquired: typing.ClassVar[QRemoteObjectNode.ErrorCode] = ...
    ServerAlreadyCreated: typing.ClassVar[QRemoteObjectNode.ErrorCode] = ...
    SourceNotRegistered: typing.ClassVar[QRemoteObjectNode.ErrorCode] = ...
    UnintendedRegistryHosting: typing.ClassVar[QRemoteObjectNode.ErrorCode] = ...
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    heartbeatIntervalChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    remoteObjectAdded: typing.ClassVar[PySide2.QtCore.Signal] = ...
    remoteObjectRemoved: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, registryAddress: PySide2.QtCore.QUrl, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., error: typing.Callable = ..., heartbeatInterval: int = ..., heartbeatIntervalChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., persistedStore: QRemoteObjectAbstractPersistedStore = ..., registryUrl: PySide2.QtCore.QUrl = ..., remoteObjectAdded: typing.Callable = ..., remoteObjectRemoved: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., error: typing.Callable = ..., heartbeatInterval: int = ..., heartbeatIntervalChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., persistedStore: QRemoteObjectAbstractPersistedStore = ..., registryUrl: PySide2.QtCore.QUrl = ..., remoteObjectAdded: typing.Callable = ..., remoteObjectRemoved: typing.Callable = ...) -> None: ...
    def acquireDynamic(self, name: str) -> QRemoteObjectDynamicReplica: ...
    def acquireModel(self, name: str) -> QAbstractItemModelReplica: ...
    def addClientSideConnection(self, ioDevice: PySide2.QtCore.QIODevice) -> None: ...
    def connectToNode(self, address: PySide2.QtCore.QUrl) -> bool: ...
    def heartbeatInterval(self) -> int: ...
    def instances(self, typeName: str) -> typing.List[str]: ...
    def lastError(self) -> QRemoteObjectNode.ErrorCode: ...
    def persistedStore(self) -> QRemoteObjectAbstractPersistedStore: ...
    def registry(self) -> QRemoteObjectRegistry: ...
    def registryUrl(self) -> PySide2.QtCore.QUrl: ...
    def setHeartbeatInterval(self, interval: int) -> None: ...
    def setName(self, name: str) -> None: ...
    def setPersistedStore(self, persistedStore: QRemoteObjectAbstractPersistedStore) -> None: ...
    def setRegistryUrl(self, registryAddress: PySide2.QtCore.QUrl) -> bool: ...
    def timerEvent(self, arg__1: PySide2.QtCore.QTimerEvent) -> None: ...
    def waitForRegistry(self, timeout: int = ...) -> bool: ...

class QRemoteObjectPendingCall(shiboken2.Object):
    class Error:
        InvalidMessage: typing.ClassVar[QRemoteObjectPendingCall.Error] = ...
        NoError: typing.ClassVar[QRemoteObjectPendingCall.Error] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QRemoteObjectPendingCall.Error: ...
        def __and__(self, other: typing.SupportsInt) -> QRemoteObjectPendingCall.Error: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QRemoteObjectPendingCall.Error: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QRemoteObjectPendingCall.Error: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QRemoteObjectPendingCall.Error: ...
        def __rand__(self, other: typing.SupportsInt) -> QRemoteObjectPendingCall.Error: ...
        def __rmul__(self, other: typing.SupportsInt) -> QRemoteObjectPendingCall.Error: ...
        def __ror__(self, other: typing.SupportsInt) -> QRemoteObjectPendingCall.Error: ...
        def __rsub__(self, other: typing.SupportsInt) -> QRemoteObjectPendingCall.Error: ...
        def __rxor__(self, other: typing.SupportsInt) -> QRemoteObjectPendingCall.Error: ...
        def __sub__(self, other: typing.SupportsInt) -> QRemoteObjectPendingCall.Error: ...
        def __xor__(self, other: typing.SupportsInt) -> QRemoteObjectPendingCall.Error: ...
    InvalidMessage: typing.ClassVar[QRemoteObjectPendingCall.Error] = ...
    NoError: typing.ClassVar[QRemoteObjectPendingCall.Error] = ...
    @overload
    def __init__(self, other: QRemoteObjectPendingCall) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def error(self) -> QRemoteObjectPendingCall.Error: ...
    @classmethod
    def fromCompletedCall(cls, returnValue: typing.Any) -> QRemoteObjectPendingCall: ...
    def isFinished(self) -> bool: ...
    def returnValue(self) -> typing.Any: ...
    def waitForFinished(self, timeout: int = ...) -> bool: ...

class QRemoteObjectPendingCallWatcher(PySide2.QtCore.QObject, QRemoteObjectPendingCall):
    finished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, call: QRemoteObjectPendingCall, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def isFinished(self) -> bool: ...
    def waitForFinished(self) -> None: ...

class QRemoteObjectRegistry(QRemoteObjectReplica):
    remoteObjectAdded: typing.ClassVar[PySide2.QtCore.Signal] = ...
    remoteObjectRemoved: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def addSource(self, entry: typing.Tuple[str,QRemoteObjectSourceLocationInfo]) -> None: ...
    def initialize(self) -> None: ...
    def pushToRegistryIfNeeded(self) -> None: ...
    @classmethod
    def registerMetatypes(cls) -> None: ...
    def removeSource(self, entry: typing.Tuple[str,QRemoteObjectSourceLocationInfo]) -> None: ...
    def sourceLocations(self) -> typing.Dict[str,QRemoteObjectSourceLocationInfo]: ...

class QRemoteObjectRegistryHost(QRemoteObjectHostBase):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, registryAddress: PySide2.QtCore.QUrl = ..., parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., error: typing.Callable = ..., heartbeatInterval: int = ..., heartbeatIntervalChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., persistedStore: typing.Any = ..., registryUrl: PySide2.QtCore.QUrl = ..., remoteObjectAdded: typing.Callable = ..., remoteObjectRemoved: typing.Callable = ...) -> None: ...
    def setRegistryUrl(self, registryUrl: PySide2.QtCore.QUrl) -> bool: ...

class QRemoteObjectReplica(PySide2.QtCore.QObject):
    class State:
        Default: typing.ClassVar[QRemoteObjectReplica.State] = ...
        SignatureMismatch: typing.ClassVar[QRemoteObjectReplica.State] = ...
        Suspect: typing.ClassVar[QRemoteObjectReplica.State] = ...
        Uninitialized: typing.ClassVar[QRemoteObjectReplica.State] = ...
        Valid: typing.ClassVar[QRemoteObjectReplica.State] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QRemoteObjectReplica.State: ...
        def __and__(self, other: typing.SupportsInt) -> QRemoteObjectReplica.State: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QRemoteObjectReplica.State: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QRemoteObjectReplica.State: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QRemoteObjectReplica.State: ...
        def __rand__(self, other: typing.SupportsInt) -> QRemoteObjectReplica.State: ...
        def __rmul__(self, other: typing.SupportsInt) -> QRemoteObjectReplica.State: ...
        def __ror__(self, other: typing.SupportsInt) -> QRemoteObjectReplica.State: ...
        def __rsub__(self, other: typing.SupportsInt) -> QRemoteObjectReplica.State: ...
        def __rxor__(self, other: typing.SupportsInt) -> QRemoteObjectReplica.State: ...
        def __sub__(self, other: typing.SupportsInt) -> QRemoteObjectReplica.State: ...
        def __xor__(self, other: typing.SupportsInt) -> QRemoteObjectReplica.State: ...
    Default: typing.ClassVar[QRemoteObjectReplica.State] = ...
    SignatureMismatch: typing.ClassVar[QRemoteObjectReplica.State] = ...
    Suspect: typing.ClassVar[QRemoteObjectReplica.State] = ...
    Uninitialized: typing.ClassVar[QRemoteObjectReplica.State] = ...
    Valid: typing.ClassVar[QRemoteObjectReplica.State] = ...
    initialized: typing.ClassVar[PySide2.QtCore.Signal] = ...
    notified: typing.ClassVar[PySide2.QtCore.Signal] = ...
    stateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, destroyed: typing.Callable = ..., initialized: typing.Callable = ..., node: QRemoteObjectNode = ..., notified: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., state: QRemoteObjectReplica.State = ..., stateChanged: typing.Callable = ...) -> None: ...
    def initialize(self) -> None: ...
    def initializeNode(self, node: QRemoteObjectNode, name: str = ...) -> None: ...
    def isInitialized(self) -> bool: ...
    def isReplicaValid(self) -> bool: ...
    def node(self) -> QRemoteObjectNode: ...
    def persistProperties(self, repName: str, repSig: typing.Union[PySide2.QtCore.QByteArray,bytes], props: typing.Iterable[typing.Any]) -> None: ...
    def propAsVariant(self, i: int) -> typing.Any: ...
    def retrieveProperties(self, repName: str, repSig: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> typing.List[typing.Any]: ...
    def send(self, call: PySide2.QtCore.QMetaObject.Call, index: int, args: typing.Iterable[typing.Any]) -> None: ...
    def sendWithReply(self, call: PySide2.QtCore.QMetaObject.Call, index: int, args: typing.Iterable[typing.Any]) -> QRemoteObjectPendingCall: ...
    def setChild(self, i: int, arg__2: typing.Any) -> None: ...
    def setNode(self, node: QRemoteObjectNode) -> None: ...
    def setProperties(self, arg__1: typing.Iterable[typing.Any]) -> None: ...
    def state(self) -> QRemoteObjectReplica.State: ...
    def waitForSource(self, timeout: int = ...) -> bool: ...

class QRemoteObjectSettingsStore(QRemoteObjectAbstractPersistedStore):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def restoreProperties(self, repName: str, repSig: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> typing.List[typing.Any]: ...
    def saveProperties(self, repName: str, repSig: typing.Union[PySide2.QtCore.QByteArray,bytes], values: typing.Iterable[typing.Any]) -> None: ...

class QRemoteObjectSourceLocationInfo(shiboken2.Object):
    hostUrl: typing.Any
    typeName: typing.Any
    @overload
    def __init__(self, typeName_: str, hostUrl_: PySide2.QtCore.QUrl) -> None: ...
    @overload
    def __init__(self, QRemoteObjectSourceLocationInfo: QRemoteObjectSourceLocationInfo) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, stream: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, stream: PySide2.QtCore.QDataStream) -> PySide2.QtCore.QDataStream: ...
