from axipy.cpp_core_dp import Converter

from .data_provider import DataProvider
from .source import Source, Destination
from ..schema import Schema

__all__ = [
    "MifMidDestination",
    "MifMidDataProvider",
]


class MifMidDestination(Destination):
    pass


class MifMidDataProvider(DataProvider):
    """Провайдер данных MIF-MID.
    
    Note:
        Поддерживает экспорт только в TAB. См. :meth:`convert_to_tab`.
        
    Note:
        Ссылку на провайдер можно получить через глобальную переменную :attr:`axipy.da.provider_manager.mif`.
    """
    _identifier = 'MifMidDataProvider'

    def get_source(self) -> Source:
        """
        Attention:
            Не поддерживается.

        Raises:
            NotImplementedError
        """
        raise NotImplementedError

    def create_open(self):
        """
        Attention:
            Не поддерживается.

        Raises:
            NotImplementedError
        """
        raise NotImplementedError

    def get_destination(self, filepath: str, schema: Schema) -> Destination:
        """Создает назначение объекта данных.

        Args:
            filepath: Путь к файлу.
            schema: Схема таблицы.
        """
        return MifMidDestination(schema,
                                 Source._provider(self.id),
                                 Source._table_file(filepath),
                                 )

    def open(self):
        """
        Attention:
            Не поддерживается.

        Raises:
            NotImplementedError
        """
        raise NotImplementedError

    def convert_to_tab(self, mif_filepath: str, tab_filepath: str):
        """Конвертирует из MIF в TAB.

        .. literalinclude:: /../../tests/doc_examples/da/test_example_export.py
            :pyobject: test_run_example_export_mif
            :lines: 2-5, 11-
            :dedent: 4
            :caption: Пример экспорта

        Args:
            mif_filepath: Путь к исходному файлу.
            tab_filepath: Путь к выходному файлу.
        Raises:
            Exception: Если при конвертации произошла ошибка.
        """
        mif_source = MifMidDestination(Schema(),
                                       Source._provider(self.id),
                                       Source._table_file(mif_filepath),
                                       {'access': 'ro'}
                                       )
        tab_dest = MifMidDestination(
            Schema(),
            Source._provider('TabDataProvider'),
            Source._table_file(tab_filepath)
        )
        Converter.convertMifToTab(mif_source, tab_dest)
