from .layer import ThematicLayer
from PySide2.QtGui import QColor
from _typeshed import Incomplete
from axipy.da import Style
from typing import Any, List, Tuple

class StyledByIndexThematic:
    def get_style(self, idx: int) -> Style: ...
    def set_style(self, idx: int, style: Style): ...

class ReallocateThematicColor:
    def assign_two_colors(self, colorMin: QColor, colorMax: QColor, useHSV: bool = ...): ...
    def assign_three_colors(self, colorMin: QColor, colorMax: QColor, colorBreak: QColor, br: int, useHSV: bool = ...): ...
    def assign_rainbow(self, sequential: bool = ..., saturation: float = ..., value: float = ...): ...
    def assign_gray(self, minV: int = ..., maxV: int = ...): ...
    def assign_monotone(self, color: QColor, minv: int = ..., maxv: int = ...): ...

class RangeThematicLayer(ThematicLayer, StyledByIndexThematic, ReallocateThematicColor):
    def __init__(self, expression: str) -> None: ...
    @property
    def ranges(self) -> int: ...
    @ranges.setter
    def ranges(self, n: int): ...
    EQUAL_INTERVAL: int
    EQUAL_COUNT: int
    MANUAL: int
    @property
    def splitType(self) -> int: ...
    @splitType.setter
    def splitType(self, n: int): ...
    def get_interval_value(self, idx: int) -> Tuple[float, float]: ...
    def set_interval_value(self, idx: int, v: Tuple[float, float]): ...

def create_range(expression: str, ranges: int = ..., colorMin=..., colorMax=..., splitType=...): ...

class AllocationThematic:
    LINEAR: int
    SQRT: int
    LOG10: int
    @property
    def allocationType(self) -> int: ...
    @allocationType.setter
    def allocationType(self, n: int): ...

class OrientationThematic:
    CENTER: Incomplete
    LEFT_UP: int
    UP: int
    RIGHT_UP: int
    RIGHT: int
    RIGHT_DOWN: int
    DOWN: int
    LEFT_DOWN: int
    LEFT: int
    @property
    def orientationType(self) -> int: ...
    @orientationType.setter
    def orientationType(self, n: int): ...

class PieThematicLayer(ThematicLayer, AllocationThematic, OrientationThematic, StyledByIndexThematic):
    def __init__(self, expressions: List) -> None: ...
    @property
    def startAngle(self) -> bool: ...
    @startAngle.setter
    def startAngle(self, v: float): ...

def create_pie(expressions: List, allocationType: int = ...): ...

class BarThematicLayer(ThematicLayer, AllocationThematic, OrientationThematic, StyledByIndexThematic):
    def __init__(self, expressions: List) -> None: ...
    @property
    def isStacked(self) -> bool: ...
    @isStacked.setter
    def isStacked(self, v: bool): ...

class SymbolThematicLayer(ThematicLayer):
    def __init__(self, expression: str) -> None: ...
    @property
    def minHeight(self) -> float: ...
    @minHeight.setter
    def minHeight(self, v: float): ...
    @property
    def maxHeight(self) -> float: ...
    @maxHeight.setter
    def maxHeight(self, v: float): ...
    @property
    def defaultStyle(self) -> Style: ...
    @defaultStyle.setter
    def defaultStyle(self, style: Style): ...

class IndividualThematicLayer(ThematicLayer, StyledByIndexThematic, ReallocateThematicColor):
    def __init__(self, expression: str) -> None: ...
    @property
    def count(self): ...
    def get_value(self, idx: int) -> Any: ...
    def __len__(self) -> int: ...

class DensityThematicLayer(ThematicLayer):
    def __init__(self, expression: str) -> None: ...
    @property
    def pointForMaximum(self) -> int: ...
    @pointForMaximum.setter
    def pointForMaximum(self, cnt: int): ...
    @property
    def color(self) -> QColor: ...
    @color.setter
    def color(self, c: QColor): ...
    @property
    def size(self) -> float: ...
    @size.setter
    def size(self, v: float): ...
