from .context import Context
from .legend import Legend
from .map_ import Map
from PySide2.QtCore import QPointF, QRectF, QSizeF, Signal
from PySide2.QtPrintSupport import QPrinter
from axipy.cpp_render import ShadowGeometryReportItem, ShadowLegendReportItem, ShadowMapReportItem, ShadowRasterReportItem, ShadowScaleBarReportItem, ShadowTableReportItem
from axipy.cs import LinearUnit
from axipy.da import Geometry, Style, Table
from axipy.utl import Pnt, Rect
from typing import Union

class ReportItem:
    @property
    def rect(self) -> Rect: ...
    @rect.setter
    def rect(self, r: Union[Rect, QRectF]): ...
    def intersects(self, checkRect: Union[Rect, QRectF]): ...
    @property
    def border_style(self) -> Style: ...
    @border_style.setter
    def border_style(self, s: Style): ...
    @property
    def fill_style(self) -> Style: ...
    @fill_style.setter
    def fill_style(self, s: Style): ...

class ReportItems:
    def __init__(self) -> None: ...
    def add(self, item: ReportItem): ...
    @property
    def count(self) -> int: ...
    def at(self, idx: int) -> ReportItem: ...
    def __getitem__(self, idx: int): ...
    def remove(self, idx: int): ...
    def __len__(self) -> int: ...
    def __iter__(self): ...

class Report:
    def __init__(self, printer: QPrinter) -> None: ...
    @property
    def need_redraw(self, rect: Union[Rect, QRectF]) -> Signal: ...
    def draw(self, context: Context): ...
    @property
    def items(self) -> ReportItems: ...
    @property
    def horisontal_pages(self) -> int: ...
    @horisontal_pages.setter
    def horisontal_pages(self, v: int): ...
    @property
    def vertical_pages(self) -> int: ...
    @vertical_pages.setter
    def vertical_pages(self, v: int): ...
    @property
    def unit(self) -> LinearUnit: ...
    @unit.setter
    def unit(self, unit: LinearUnit): ...
    @property
    def page_size(self) -> QSizeF: ...
    @property
    def name(self) -> str: ...
    @name.setter
    def name(self, n) -> None: ...
    def fill_on_pages(self) -> None: ...
    def fit_pages(self) -> None: ...

class GeometryReportItem(ReportItem):
    def __init__(self) -> None: ...
    @classmethod
    def create(cls, _shadow: ShadowGeometryReportItem): ...
    @property
    def geometry(self) -> Geometry: ...
    @geometry.setter
    def geometry(self, g: Geometry): ...
    @property
    def style(self) -> Style: ...
    @style.setter
    def style(self, s: Style): ...

class MapReportItem(ReportItem):
    def __init__(self, rect: Union[Rect, QRectF], map: Map) -> None: ...
    @classmethod
    def create(cls, _shadow: ShadowMapReportItem): ...
    def map(self) -> Map: ...
    @property
    def center(self) -> Pnt: ...
    @center.setter
    def center(self, c: Union[Pnt, QPointF]): ...
    @property
    def scale(self) -> float: ...
    @scale.setter
    def scale(self, s: float): ...
    @property
    def map_rect(self) -> Rect: ...
    def show_all(self) -> None: ...

class RasterReportItem(ReportItem):
    def __init__(self, rect: Union[Rect, QRectF], data: str) -> None: ...
    @classmethod
    def create(cls, _shadow: ShadowRasterReportItem): ...
    @property
    def preserve_aspect_ratio(self) -> bool: ...
    @preserve_aspect_ratio.setter
    def preserve_aspect_ratio(self, v: bool): ...

class TableReportItem(ReportItem):
    def __init__(self, rect: Union[Rect, QRectF], table: Table) -> None: ...
    @classmethod
    def create(cls, _shadow: ShadowTableReportItem): ...
    @property
    def columns(self) -> list: ...
    @columns.setter
    def columns(self, l) -> None: ...
    def refreshValues(self) -> None: ...
    @property
    def row_from(self) -> int: ...
    @row_from.setter
    def row_from(self, l) -> None: ...
    @property
    def row_count(self) -> int: ...
    @row_count.setter
    def row_count(self, l) -> None: ...
    @property
    def start_number(self) -> int: ...
    @start_number.setter
    def start_number(self, l) -> None: ...
    def table(self) -> Table: ...

class LegendReportItem(ReportItem):
    def __init__(self, rect: Union[Rect, QRectF], legend: Legend) -> None: ...
    @classmethod
    def create(cls, _shadow: ShadowLegendReportItem): ...
    @property
    def legend(self) -> Legend: ...

class ScaleBarReportItem(ReportItem):
    def __init__(self, rect: Union[Rect, QRectF], map: MapReportItem) -> None: ...
    @classmethod
    def create(cls, _shadow: ShadowScaleBarReportItem): ...
