from .context import Context
from .layer import Layer
from PySide2.QtCore import QPointF
from PySide2.QtGui import QImage
from axipy.da import Style
from axipy.utl import Pnt
from typing import Union

class LegendItem:
    def __init__(self) -> None: ...
    @property
    def visible(self) -> bool: ...
    @visible.setter
    def visible(self, v) -> None: ...
    @property
    def title(self) -> str: ...
    @title.setter
    def title(self, v) -> None: ...
    @property
    def style(self) -> Style: ...

class ListLegendItems:
    def __init__(self) -> None: ...
    def move(self, fromIdx: int, toIdx: int): ...
    def __getitem__(self, item: int): ...
    def __setitem__(self, idx, v) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self): ...

class Legend:
    def __init__(self, lay: Layer) -> None: ...
    def draw(self, context: Context): ...
    @property
    def position(self) -> Pnt: ...
    @position.setter
    def position(self, pos: Union[Pnt, QPointF, tuple]): ...
    @property
    def caption(self) -> str: ...
    @caption.setter
    def caption(self, s: str): ...
    @property
    def style_caption(self) -> Style: ...
    @style_caption.setter
    def style_caption(self, style: Style): ...
    @property
    def subcaption(self) -> str: ...
    @subcaption.setter
    def subcaption(self, s: str): ...
    @property
    def style_subcaption(self) -> Style: ...
    @style_subcaption.setter
    def style_subcaption(self, style: Style): ...
    @property
    def style_text(self) -> Style: ...
    @style_text.setter
    def style_text(self, style: Style): ...
    @property
    def border_style(self) -> Style: ...
    @border_style.setter
    def border_style(self, s: Style): ...
    @property
    def fill_style(self) -> Style: ...
    @fill_style.setter
    def fill_style(self, s: Style): ...
    @property
    def columns(self) -> int: ...
    @columns.setter
    def columns(self, v) -> None: ...
    def refresh(self) -> None: ...
    @property
    def items(self) -> ListLegendItems: ...
    def to_image(self, width: int, height: int) -> QImage: ...
