from PySide2.QtCore import QSize
from PySide2.QtGui import QColor, QFont
from _typeshed import Incomplete
from axipy.da import Point
from enum import Enum

class LabelOverlap(int, Enum):
    AllowOverlap: int
    DisallowOverlap: int
    OtherPosition: int

class LabelBackgroundType(int, Enum):
    Empty: int
    Outline: int
    Frame: int

class LabelLinePosition(int, Enum):
    Horizontal: int
    Parallel: int
    FollowPath: int

class LabelAreaPosition(int, Enum):
    Centroid: int
    Horizontal: int
    Vertical: int
    Automatic: int

class LabelAreaInterior(int, Enum):
    Max: int
    Centroid: int

class LabelHorizontalAlign(int, Enum):
    Flat: Incomplete
    Center: Incomplete
    Begin: Incomplete
    End: int

class LabelLayoutPosition(int, Enum):
    Center: Incomplete
    TopLeft: Incomplete
    Top: Incomplete
    TopRight: Incomplete
    Right: Incomplete
    BottomRight: Incomplete
    Bottom: Incomplete
    BottomLeft: Incomplete
    Left: int

class LabelLayout:
    def __init__(self) -> None: ...
    @property
    def position(self) -> LabelLayoutPosition: ...
    @position.setter
    def position(self, p: LabelLayoutPosition): ...
    @property
    def visible(self) -> bool: ...
    @visible.setter
    def visible(self, v: bool): ...
    @property
    def offset(self) -> QSize: ...
    @offset.setter
    def offset(self, v: QSize): ...

class Label:
    def __init__(self) -> None: ...
    @property
    def text(self) -> str: ...
    @text.setter
    def text(self, n: str): ...
    @property
    def visible(self) -> bool: ...
    @visible.setter
    def visible(self, v: bool): ...
    @property
    def placementPolicy(self) -> LabelOverlap: ...
    @placementPolicy.setter
    def placementPolicy(self, n: LabelOverlap): ...
    @property
    def color(self) -> QColor: ...
    @color.setter
    def color(self, v: QColor): ...
    @property
    def opacity(self) -> int: ...
    @opacity.setter
    def opacity(self, v: int): ...
    @property
    def rangeEnabled(self) -> bool: ...
    @rangeEnabled.setter
    def rangeEnabled(self, v: bool): ...
    @property
    def rangeMin(self) -> float: ...
    @rangeMin.setter
    def rangeMin(self, v: float): ...
    @property
    def rangeMax(self) -> float: ...
    @rangeMax.setter
    def rangeMax(self, v: float): ...
    @property
    def font(self) -> QFont: ...
    @font.setter
    def font(self, v: QFont): ...
    @property
    def spacing(self) -> bool: ...
    @spacing.setter
    def spacing(self, v: bool): ...
    @property
    def shadow(self) -> bool: ...
    @shadow.setter
    def shadow(self, v: bool): ...
    @property
    def backgroundType(self) -> LabelBackgroundType: ...
    @backgroundType.setter
    def backgroundType(self, v: LabelBackgroundType): ...
    @property
    def backgroundColor(self) -> QColor: ...
    @backgroundColor.setter
    def backgroundColor(self, v: QColor): ...
    @property
    def backgroundSize(self) -> int: ...
    @backgroundSize.setter
    def backgroundSize(self, v: int): ...
    @property
    def lineKeepDirection(self) -> bool: ...
    @lineKeepDirection.setter
    def lineKeepDirection(self, v: bool): ...
    @property
    def linePosition(self) -> LabelLinePosition: ...
    @linePosition.setter
    def linePosition(self, v: LabelLinePosition): ...
    @property
    def areaPosition(self) -> LabelAreaPosition: ...
    @areaPosition.setter
    def areaPosition(self, v: LabelAreaPosition): ...
    @property
    def areaInterior(self) -> LabelAreaInterior: ...
    @areaInterior.setter
    def areaInterior(self, v: LabelAreaInterior): ...
    @property
    def pointLayout(self) -> LabelLayout: ...
    @pointLayout.setter
    def pointLayout(self, v: LabelLayout): ...
    @property
    def lineLayout(self) -> LabelLayout: ...
    @lineLayout.setter
    def lineLayout(self, v: LabelLayout): ...
    @property
    def areaLayout(self) -> LabelLayout: ...
    @areaLayout.setter
    def areaLayout(self, v: LabelLayout): ...
    @property
    def useClip(self) -> bool: ...
    @useClip.setter
    def useClip(self, v: bool): ...
    @property
    def supressDuplicates(self) -> bool: ...
    @supressDuplicates.setter
    def supressDuplicates(self, v: bool): ...
    @property
    def horizontalAlign(self) -> LabelHorizontalAlign: ...
    @horizontalAlign.setter
    def horizontalAlign(self, v: LabelHorizontalAlign): ...
    @property
    def overhang(self) -> int: ...
    @overhang.setter
    def overhang(self, v: int): ...

class CustomLabelEndType(int, Enum):
    EndNone: int
    Line: int
    Arrow: int

class CustomLabelProperties:
    def __init__(self) -> None: ...
    @property
    def expression(self) -> str: ...
    @expression.setter
    def expression(self, v: str): ...
    @property
    def angle(self) -> float: ...
    @angle.setter
    def angle(self, v: float): ...
    @property
    def endType(self) -> CustomLabelEndType: ...
    @endType.setter
    def endType(self, v: CustomLabelEndType): ...
    @property
    def position(self) -> Point: ...
    @position.setter
    def position(self, p: Point): ...
