from PySide2.QtCore import QPointF, QRectF
from axipy.cs import CoordSystem
from axipy.da import Geometry, Polygon, Style
from axipy.gui import MapView, ReportView
from axipy.utl import Pnt, Rect
from typing import Union

class Rectangle(Geometry):
    def __init__(self, *par: Union[Rect, float], cs: CoordSystem = ...) -> None: ...
    @property
    def xmin(self) -> float: ...
    @xmin.setter
    def xmin(self, v: float): ...
    @property
    def ymin(self) -> float: ...
    @ymin.setter
    def ymin(self, v: float): ...
    @property
    def xmax(self) -> float: ...
    @xmax.setter
    def xmax(self, v: float): ...
    @property
    def ymax(self) -> float: ...
    @ymax.setter
    def ymax(self, v: float): ...

class RoundRectangle(Rectangle):
    def __init__(self, rect: Union[Rect, list], xRad: float, yRad: float, cs: CoordSystem = ...) -> None: ...
    @property
    def xRadius(self) -> float: ...
    @xRadius.setter
    def xRadius(self, v) -> None: ...
    @property
    def yRadius(self) -> float: ...
    @yRadius.setter
    def yRadius(self, v) -> None: ...

class Ellipse(Geometry):
    def __init__(self, rect: Union[Rect, list], cs: CoordSystem = ...) -> None: ...
    @property
    def center(self) -> Pnt: ...
    @center.setter
    def center(self, v: Union[Pnt, tuple]): ...
    @property
    def majorSemiAxis(self) -> float: ...
    @majorSemiAxis.setter
    def majorSemiAxis(self, v: float): ...
    @property
    def minorSemiAxis(self) -> float: ...
    @minorSemiAxis.setter
    def minorSemiAxis(self, v: float): ...

class Arc(Geometry):
    def __init__(self, rect: Union[Rect, list], startAngle: float, endAngle: float, cs: CoordSystem = ...) -> None: ...
    @property
    def center(self) -> Pnt: ...
    @center.setter
    def center(self, v: Union[Pnt, tuple]): ...
    @property
    def xRadius(self) -> float: ...
    @xRadius.setter
    def xRadius(self, v: float): ...
    @property
    def yRadius(self) -> float: ...
    @yRadius.setter
    def yRadius(self, v: float): ...
    @property
    def startAngle(self) -> float: ...
    @startAngle.setter
    def startAngle(self, v: float): ...
    @property
    def endAngle(self) -> float: ...
    @endAngle.setter
    def endAngle(self, v: float): ...

class Text(Geometry):
    def __init__(self, text: str, rect: Union[Rect, QRectF], view: Union[MapView, ReportView] = ..., angle: float = ..., cs: CoordSystem = ...) -> None: ...
    @classmethod
    def create_by_style(cls, text: str, point: Union[Pnt, QPointF], style: Style, view: Union[MapView, ReportView], angle: float = ..., cs: CoordSystem = ...): ...
    @property
    def startPoint(self) -> Pnt: ...
    @startPoint.setter
    def startPoint(self, v: Union[Pnt, tuple]): ...
    @property
    def endPoint(self) -> Pnt: ...
    @endPoint.setter
    def endPoint(self, v: Union[Pnt, tuple]): ...
    @property
    def text(self) -> str: ...
    @text.setter
    def text(self, v: str): ...
    @property
    def angle(self) -> float: ...
    @angle.setter
    def angle(self, a: float): ...
    @property
    def rect_as_polygon(self) -> Polygon: ...
    @property
    def width(self): ...
    @property
    def height(self): ...
    def size_for_view(self, style, view: Union[MapView, ReportView]) -> float: ...
