from axipy.cs import CoordSystem
from typing import List, Optional, Union

class Attribute:
    DEFAULT_STRING_LENGTH: int
    DEFAULT_DECIMAL_LENGTH: int
    DEFAULT_DECIMAL_PRECISION: int
    def __init__(self, name: str, typedef: str) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def typedef(self) -> str: ...
    @property
    def length(self) -> int: ...
    @property
    def precision(self) -> int: ...
    @property
    def type_string(self) -> str: ...
    @staticmethod
    def string(name: str, length: int = ...) -> Attribute: ...
    @staticmethod
    def decimal(name: str, length: int = ..., precision: int = ...) -> Attribute: ...
    @staticmethod
    def integer(name: str) -> Attribute: ...
    @staticmethod
    def float(name: str) -> Attribute: ...
    @staticmethod
    def double(name: str) -> Attribute: ...
    @staticmethod
    def bool(name: str) -> Attribute: ...
    @staticmethod
    def date(name: str) -> Attribute: ...
    @staticmethod
    def time(name: str) -> Attribute: ...
    @staticmethod
    def datetime(name: str) -> Attribute: ...
    def __eq__(self, other: Union['Attribute', str]) -> bool: ...

class Schema(list):
    def __init__(self, *attributes: Attribute, coordsystem: Union[str, CoordSystem] = ...) -> None: ...
    def to_dict(self) -> dict: ...
    @property
    def attribute_names(self) -> List[str]: ...
    def insert(self, index: int, attr: Attribute): ...
    def __contains__(self, name: str) -> bool: ...
    @property
    def coordsystem(self) -> Optional[CoordSystem]: ...
    @coordsystem.setter
    def coordsystem(self, cs: Union[CoordSystem, str]): ...
    def by_name(self, n: str) -> Attribute: ...
    def index_by_name(self, n: str) -> int: ...
    def __len__(self) -> int: ...
