from PySide2.QtCore import QPointF
from PySide2.QtGui import QTransform
from axipy.cs import CoordSystem
from enum import Enum
from typing import List, NamedTuple, Tuple, Union

class GCP(NamedTuple):
    device: Union[Tuple[float, float], QPointF]
    scene: Union[Tuple[float, float], QPointF]
    label: str

class Algorithm(Enum):
    POLYNOM1: int
    POLYNOM2: int
    POLYNOM3: int
    SPLINE: int

class Compression(Enum):
    NONE: int
    PACKBITS: int
    LZW: int
    DEFLATE: int

class Format(Enum):
    JPEG: int
    PNG: int
    BMP: int
    GTiff: int

class Resample(Enum):
    NearestNeighbour: int
    Bilinear: int
    Cubic: int
    CubicSpline: int
    Lanczos: int
    Average: int
    Mode: int
    Max: int
    Min: int
    Med: int
    Q1: int
    Q3: int
    Sum: int

def register(filepath: str, bindings: Union[List[GCP], QTransform], coordsystem: CoordSystem, override: bool = ...): ...
def transform(inputfile: str, outputfile: str, points: List[GCP], coordsystem: CoordSystem, algorithm: Algorithm = ..., resample: Resample = ..., output_format: Format = ..., compression: Compression = ...): ...
