from .unit import LinearUnit
from PySide2.QtCore import QPointF, QRectF
from axipy.utl import Pnt, Rect
from typing import List, Optional, Union

class CoordSystem:
    def __init__(self) -> None: ...
    @staticmethod
    def factory(): ...
    @property
    def description(self) -> str: ...
    @property
    def title(self) -> str: ...
    @property
    def rect(self) -> Rect: ...
    @rect.setter
    def rect(self, r: Rect): ...
    @property
    def unit(self) -> LinearUnit: ...
    def convert_to_degree(self, value: Union[Pnt, Rect, QPointF, List[QPointF], QRectF]) -> Union[Pnt, List[Pnt], Rect]: ...
    def convert_from_degree(self, value: Union[Pnt, Rect, QPointF, List[QPointF], QRectF]) -> Union[Pnt, List[Pnt], Rect]: ...
    @property
    def epsg(self) -> Optional[int]: ...
    @property
    def proj(self) -> str: ...
    @property
    def prj(self) -> str: ...
    @property
    def wkt(self) -> str: ...
    @property
    def non_earth(self) -> bool: ...
    @property
    def lat_lon(self) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def semi_major(self) -> float: ...
    @property
    def semi_minor(self) -> float: ...
    @property
    def inv_flattening(self) -> float: ...
    @classmethod
    def from_epsg(cls, code: int) -> CoordSystem: ...
    @classmethod
    def from_wkt(cls, wkt: str) -> CoordSystem: ...
    @classmethod
    def from_proj(cls, proj: str) -> CoordSystem: ...
    @classmethod
    def from_prj(cls, prj: str) -> CoordSystem: ...
    @classmethod
    def from_units(cls, unit: LinearUnit, rect: Optional[Union[Rect, QRectF]] = ...) -> CoordSystem: ...
    @classmethod
    def from_string(cls, string: str) -> CoordSystem: ...
    def to_string(self) -> str: ...
    def __eq__(self, other) -> bool: ...
    @classmethod
    def current(cls) -> CoordSystem: ...
    @classmethod
    def set_current(cls, coordsystem: CoordSystem): ...
