import abc
from .task import AxipyTask
from .task_utils import ProgressSpecification
from PySide2.QtWidgets import QDialog
from _typeshed import Incomplete
from abc import abstractmethod
from typing import Any, Callable

class _ProgressElementFactoryInterace(metaclass=abc.ABCMeta):
    @abstractmethod
    def make_dialog_for_task(self, task: AxipyTask, spec: ProgressSpecification): ...

class _ProgressElementFactory(_ProgressElementFactoryInterace):
    def __init__(self) -> None: ...
    @property
    def factory(self) -> _ProgressElementFactoryInterace: ...
    @factory.setter
    def factory(self, factory: _ProgressElementFactoryInterace): ...
    def make_dialog_for_task(self, task: AxipyTask, spec: ProgressSpecification): ...
    def restore(self) -> None: ...

class TaskManager:
    def __init__(self, progress_element_factory=...) -> None: ...
    def start_task(self, task) -> None: ...
    def run_and_get(self, spec: ProgressSpecification, func: Callable, *args, **kwargs) -> Any: ...
    def run_in_gui(self, func: Callable, *args, **kwargs) -> Any: ...
    def generate_dialog_for_task(self, task: AxipyTask, spec: ProgressSpecification) -> QDialog: ...

task_manager: Incomplete
