import abc
from abc import ABC, abstractmethod
from pathlib import Path
from typing import Union

MANIFEST_FILE_NAME: str
ENTRY_POINT: str

class IParser(ABC, metaclass=abc.ABCMeta):
    @classmethod
    def create(cls): ...
    @abstractmethod
    def parse(self, location_path: Union[str, Path]) -> dict: ...
    @staticmethod
    @abstractmethod
    def supports(location_path: Union[str, Path]) -> bool: ...
    @staticmethod
    def read_config(config_fileobject) -> dict: ...
