import abc
from _typeshed import Incomplete
from abc import abstractmethod
from typing import Any, Iterator, List, Tuple

class _NoCallMeta(type):
    def __call__(cls, *args, **kwargs) -> None: ...

class _NoSetAttrMeta(type):
    def __setattr__(cls, key, value) -> None: ...

class _MappingMetaBase(type, metaclass=abc.ABCMeta):
    @abstractmethod
    def __iter__(cls) -> Iterator: ...
    @abstractmethod
    def __len__(cls) -> int: ...
    @abstractmethod
    def __getitem__(cls, key: Any) -> Any: ...
    def __contains__(cls, key) -> bool: ...
    def keys(cls): ...
    def values(cls): ...
    def items(cls): ...
    def get(cls, key, default: Incomplete | None = ...): ...
    def __eq__(cls, other): ...

class _MappingMetaReprStr(type): ...
class _MappingMetaExtended(_NoCallMeta, _NoSetAttrMeta, _MappingMetaReprStr, _MappingMetaBase, metaclass=abc.ABCMeta): ...

class _MappingMetaDocumentation(metaclass=abc.ABCMeta):
    @classmethod
    @abstractmethod
    def items(cls) -> List[Tuple[str, Any]]: ...
    @classmethod
    @abstractmethod
    def keys(cls) -> List[str]: ...
    @classmethod
    @abstractmethod
    def values(cls) -> List[Any]: ...
    @classmethod
    @abstractmethod
    def get(cls, key: str, default_value: Any = ...): ...
