import importlib
import sys
from importlib.abc import MetaPathFinder, Loader

__all__ = []

_old_names = {
    # concurrent
    "AxipyProgressHandler": "axipy_progress_handler",
    "Task": "task",
    "TaskManager": "task_manager_",
    "TaskUtils": "task_utils",
    # cs
    "CoordSystem": "coord_system",
    "CoordTransformer": "coord_transformer",
    # da
    "attribute_schema": "schema",
    "DataManagerWrapper": "data_manager_",
    "DataObjectWrapper": "data_object",
    "FeatureWrapper": "feature",
    "Geometry": "geometry",
    "Style": "style",
    "TabFile": "tab_file",
    # gui
    "ActiveToolPanel": "active_tool_panel",
    "DialogWrapper": "dialog",
    "SelectionManagerWrapper": "selection_manager_",
    "ToolWrapper": "map_tool",
    "view_manager_wrapper": "view_manager_",
    "ViewWrapper": "view",
    "WidgetWrapper": "widgets",
    "Workspace": "workspace",
    # mi
    "MIGeometry": "mi_geometry",
    # render
    "map": "map_",
}


class _AxipyDeprecLoader(Loader):

    def __init__(self, name):
        self._name = name
        super().__init__()

    def module_repr(self, module):
        return repr(module)

    def load_module(self, fullname):
        # print(f"load_module {fullname=}")
        names = fullname.split(".")
        names[-1] = self._name
        new_name = ".".join(names)
        module = importlib.import_module(new_name)
        sys.modules[fullname] = module
        return module


class _AxipyDeprecFinder(MetaPathFinder):
    def find_module(self, fullname, path=None):
        # print(f"find_module {fullname=}, {path=}")
        names = fullname.split(".")
        root_name = names[0]
        if root_name != "axipy":
            return None
        module_name = names[-1]
        if module_name in _old_names:
            return _AxipyDeprecLoader(_old_names[module_name])


sys.meta_path.append(_AxipyDeprecFinder())
