import abc
from PySide2.QtGui import QColor
from _typeshed import Incomplete
from abc import ABC, abstractmethod
from axipy._internal._metaclass import _MappingMetaDocumentation, _MappingMetaExtended
from pathlib import Path
from typing import Any, Dict, Iterator, List, Mapping, MutableMapping, Tuple, TypeVar

class _ShadowSettingsManager:
    Value = TypeVar('Value')
    ShadowValue = TypeVar('ShadowValue')
    class _MappingReprStr(ABC, metaclass=abc.ABCMeta):
        @abstractmethod
        def items(self) -> List[Tuple[str, Path]]: ...
    class _CustomMutableMapping(MutableMapping, _MappingReprStr):
        def __init__(self, dict_arg: dict) -> None: ...
        def __setitem__(self, __k, __v) -> None: ...
        def __delitem__(self, __k) -> None: ...
        def __getitem__(self, __k) -> Path: ...
        def __len__(self) -> int: ...
        def __iter__(self) -> Iterator: ...
        def keys(self) -> List[str]: ...
        def values(self) -> List[Path]: ...
        def items(self) -> List[Tuple[str, Path]]: ...
    class _CustomMapping(Mapping, _MappingReprStr):
        def __init__(self, dict_arg: dict) -> None: ...
        def __getitem__(self, __k) -> Path: ...
        def __len__(self) -> int: ...
        def __iter__(self) -> Iterator: ...
        def keys(self) -> List[str]: ...
        def values(self) -> List[Path]: ...
        def items(self) -> List[Tuple[str, Path]]: ...
    @staticmethod
    def get_value(key: str, is_default: bool) -> Value: ...
    @staticmethod
    def set_value(key: str, value: Value) -> None: ...

class _Settings(_MappingMetaDocumentation):
    class _KeysDesc:
        def __init__(self) -> None: ...
        def __get__(self, instance, owner) -> List: ...
    class _Desc:
        def __set_name__(self, owner, name: str) -> None: ...
        def __get__(self, obj, objtype: Incomplete | None = ...) -> Any: ...
    SilentCloseWidget: bool
    SnapSensitiveRadius: int
    EditNodeColor: QColor
    EditNodeSize: int
    NearlyGeometriesTopology: bool
    NodesUpdateMode: bool
    ShowDrawingToolTip: bool
    CreateTabAfterOpen: bool
    RenameDataObjectFromTab: bool
    LastSavePath: Path
    UseLastSelectedFilter: bool
    SelectByInformationTool: bool
    SaveAsToOriginalFileFolder: bool
    LastNameFilter: str
    SensitiveMouse: int
    ShowSplashScreen: bool
    RulerColorLine: QColor
    UseAntialiasing: bool
    ShowDegreeTypeNumeric: bool
    DrawCoordSysBounds: bool
    PreserveScaleMap: bool
    ShowMapScaleBar: bool
    ShowScrollOnMapView: bool
    LoadLastWorkspace: bool
    ShowMeshLayout: bool
    MeshSizeLayout: float
    SnapToMeshLayout: bool
    ShowMeshLegend: bool
    MeshSizeLegend: float
    SnapToMeshLegend: bool
    LastOpenPath: Path
    LastPathWorkspace: Path
    DefaultPathCache: Path
    UserDataPaths: Dict[str, Path]
    EnableSmartTabs: bool
    DistancePrecision: int
    PenCatalog: Path
    BrushCatalog: Path
    SymbolCatalog: Path
    UseNativeFileDialog: bool
    @classmethod
    def items(cls) -> List[Tuple[str, Any]]: ...
    @classmethod
    def keys(cls) -> List[str]: ...
    @classmethod
    def values(cls) -> List[Any]: ...
    @classmethod
    def get(cls, key: str, default_value: Any = ...): ...

class _DefaultSettingsMappingMetaExtended(_MappingMetaExtended):
    def __iter__(cls) -> Iterator: ...
    def __len__(cls) -> int: ...
    def __getitem__(cls, key: str) -> Any: ...

class DefaultSettings(_Settings, metaclass=_DefaultSettingsMappingMetaExtended): ...

class _CurrentSettingsMutableMappingMeta(_DefaultSettingsMappingMetaExtended):
    def __getitem__(cls, key: str) -> Any: ...
    def __setattr__(cls, key: str, value: Any) -> None: ...
    def __setitem__(cls, key: str, value: Any) -> None: ...

class CurrentSettings(_Settings, metaclass=_CurrentSettingsMutableMappingMeta):
    @staticmethod
    def reset() -> None: ...
