from PySide2.QtGui import QIcon
from PySide2.QtWidgets import QAction
from axipy.da import Observer
from axipy.gui import MapTool
from typing import Any, Callable, Union

class Button:
    def __init__(self) -> None: ...
    @classmethod
    def create_action(cls, title: str, icon: Union[str, QIcon] = ...): ...
    @property
    def action(self) -> QAction: ...
    @property
    def observer_id(self) -> str: ...
    def remove(self) -> None: ...

class Separator(Button):
    def __init__(self) -> None: ...

class SystemActionButton(Button):
    def __init__(self, name: str) -> None: ...
    def remove(self) -> None: ...

class ActionButton(Button):
    def __init__(self, title: str, on_click: Callable[[], Any], icon: Union[str, QIcon] = ..., enable_on: Union[str, Observer] = ..., tooltip: str = ...) -> None: ...

class ToolButton(Button):
    def __init__(self, title: str, on_click: Union[Callable[[], MapTool], MapTool], icon: Union[str, QIcon] = ..., enable_on: Union[str, Observer] = ..., tooltip: str = ...) -> None: ...

def create_button(title: str, on_click: Union[Callable[[], MapTool], MapTool], icon: Union[str, QIcon] = ..., enable_on: Union[str, Observer] = ...) -> Button: ...
def remove(button: Union[QAction, Button]): ...

class Position:
    def __init__(self, tab: str, group: str) -> None: ...
    def add(self, button: Button, size: int = ...): ...

def get_position(tab: str, group: str) -> Position: ...
