from typing import overload
import PySide2.QtCore
import PySide2.QtGui
import PySide2.QtWidgets
import shiboken2
import typing
T = typing.TypeVar('T')

class QGL(shiboken2.Object):
    class FormatOption:
        AccumBuffer: typing.ClassVar[QGL.FormatOption] = ...
        AlphaChannel: typing.ClassVar[QGL.FormatOption] = ...
        ColorIndex: typing.ClassVar[QGL.FormatOption] = ...
        DeprecatedFunctions: typing.ClassVar[QGL.FormatOption] = ...
        DepthBuffer: typing.ClassVar[QGL.FormatOption] = ...
        DirectRendering: typing.ClassVar[QGL.FormatOption] = ...
        DoubleBuffer: typing.ClassVar[QGL.FormatOption] = ...
        HasOverlay: typing.ClassVar[QGL.FormatOption] = ...
        IndirectRendering: typing.ClassVar[QGL.FormatOption] = ...
        NoAccumBuffer: typing.ClassVar[QGL.FormatOption] = ...
        NoAlphaChannel: typing.ClassVar[QGL.FormatOption] = ...
        NoDeprecatedFunctions: typing.ClassVar[QGL.FormatOption] = ...
        NoDepthBuffer: typing.ClassVar[QGL.FormatOption] = ...
        NoOverlay: typing.ClassVar[QGL.FormatOption] = ...
        NoSampleBuffers: typing.ClassVar[QGL.FormatOption] = ...
        NoStencilBuffer: typing.ClassVar[QGL.FormatOption] = ...
        NoStereoBuffers: typing.ClassVar[QGL.FormatOption] = ...
        Rgba: typing.ClassVar[QGL.FormatOption] = ...
        SampleBuffers: typing.ClassVar[QGL.FormatOption] = ...
        SingleBuffer: typing.ClassVar[QGL.FormatOption] = ...
        StencilBuffer: typing.ClassVar[QGL.FormatOption] = ...
        StereoBuffers: typing.ClassVar[QGL.FormatOption] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGL.FormatOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGL.FormatOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGL.FormatOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QGL.FormatOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QGL.FormatOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGL.FormatOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QGL.FormatOptions: ...

    class FormatOptions:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGL.FormatOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGL.FormatOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGL.FormatOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QGL.FormatOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QGL.FormatOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGL.FormatOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QGL.FormatOptions: ...
    AccumBuffer: typing.ClassVar[QGL.FormatOption] = ...
    AlphaChannel: typing.ClassVar[QGL.FormatOption] = ...
    ColorIndex: typing.ClassVar[QGL.FormatOption] = ...
    DeprecatedFunctions: typing.ClassVar[QGL.FormatOption] = ...
    DepthBuffer: typing.ClassVar[QGL.FormatOption] = ...
    DirectRendering: typing.ClassVar[QGL.FormatOption] = ...
    DoubleBuffer: typing.ClassVar[QGL.FormatOption] = ...
    HasOverlay: typing.ClassVar[QGL.FormatOption] = ...
    IndirectRendering: typing.ClassVar[QGL.FormatOption] = ...
    NoAccumBuffer: typing.ClassVar[QGL.FormatOption] = ...
    NoAlphaChannel: typing.ClassVar[QGL.FormatOption] = ...
    NoDeprecatedFunctions: typing.ClassVar[QGL.FormatOption] = ...
    NoDepthBuffer: typing.ClassVar[QGL.FormatOption] = ...
    NoOverlay: typing.ClassVar[QGL.FormatOption] = ...
    NoSampleBuffers: typing.ClassVar[QGL.FormatOption] = ...
    NoStencilBuffer: typing.ClassVar[QGL.FormatOption] = ...
    NoStereoBuffers: typing.ClassVar[QGL.FormatOption] = ...
    Rgba: typing.ClassVar[QGL.FormatOption] = ...
    SampleBuffers: typing.ClassVar[QGL.FormatOption] = ...
    SingleBuffer: typing.ClassVar[QGL.FormatOption] = ...
    StencilBuffer: typing.ClassVar[QGL.FormatOption] = ...
    StereoBuffers: typing.ClassVar[QGL.FormatOption] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...

class QGLBuffer(shiboken2.Object):
    class Access:
        ReadOnly: typing.ClassVar[QGLBuffer.Access] = ...
        ReadWrite: typing.ClassVar[QGLBuffer.Access] = ...
        WriteOnly: typing.ClassVar[QGLBuffer.Access] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGLBuffer.Access: ...
        def __and__(self, other: typing.SupportsInt) -> QGLBuffer.Access: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGLBuffer.Access: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGLBuffer.Access: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGLBuffer.Access: ...
        def __rand__(self, other: typing.SupportsInt) -> QGLBuffer.Access: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGLBuffer.Access: ...
        def __ror__(self, other: typing.SupportsInt) -> QGLBuffer.Access: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGLBuffer.Access: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGLBuffer.Access: ...
        def __sub__(self, other: typing.SupportsInt) -> QGLBuffer.Access: ...
        def __xor__(self, other: typing.SupportsInt) -> QGLBuffer.Access: ...

    class Type:
        IndexBuffer: typing.ClassVar[QGLBuffer.Type] = ...
        PixelPackBuffer: typing.ClassVar[QGLBuffer.Type] = ...
        PixelUnpackBuffer: typing.ClassVar[QGLBuffer.Type] = ...
        VertexBuffer: typing.ClassVar[QGLBuffer.Type] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGLBuffer.Type: ...
        def __and__(self, other: typing.SupportsInt) -> QGLBuffer.Type: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGLBuffer.Type: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGLBuffer.Type: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGLBuffer.Type: ...
        def __rand__(self, other: typing.SupportsInt) -> QGLBuffer.Type: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGLBuffer.Type: ...
        def __ror__(self, other: typing.SupportsInt) -> QGLBuffer.Type: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGLBuffer.Type: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGLBuffer.Type: ...
        def __sub__(self, other: typing.SupportsInt) -> QGLBuffer.Type: ...
        def __xor__(self, other: typing.SupportsInt) -> QGLBuffer.Type: ...

    class UsagePattern:
        DynamicCopy: typing.ClassVar[QGLBuffer.UsagePattern] = ...
        DynamicDraw: typing.ClassVar[QGLBuffer.UsagePattern] = ...
        DynamicRead: typing.ClassVar[QGLBuffer.UsagePattern] = ...
        StaticCopy: typing.ClassVar[QGLBuffer.UsagePattern] = ...
        StaticDraw: typing.ClassVar[QGLBuffer.UsagePattern] = ...
        StaticRead: typing.ClassVar[QGLBuffer.UsagePattern] = ...
        StreamCopy: typing.ClassVar[QGLBuffer.UsagePattern] = ...
        StreamDraw: typing.ClassVar[QGLBuffer.UsagePattern] = ...
        StreamRead: typing.ClassVar[QGLBuffer.UsagePattern] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGLBuffer.UsagePattern: ...
        def __and__(self, other: typing.SupportsInt) -> QGLBuffer.UsagePattern: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGLBuffer.UsagePattern: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGLBuffer.UsagePattern: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGLBuffer.UsagePattern: ...
        def __rand__(self, other: typing.SupportsInt) -> QGLBuffer.UsagePattern: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGLBuffer.UsagePattern: ...
        def __ror__(self, other: typing.SupportsInt) -> QGLBuffer.UsagePattern: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGLBuffer.UsagePattern: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGLBuffer.UsagePattern: ...
        def __sub__(self, other: typing.SupportsInt) -> QGLBuffer.UsagePattern: ...
        def __xor__(self, other: typing.SupportsInt) -> QGLBuffer.UsagePattern: ...
    DynamicCopy: typing.ClassVar[QGLBuffer.UsagePattern] = ...
    DynamicDraw: typing.ClassVar[QGLBuffer.UsagePattern] = ...
    DynamicRead: typing.ClassVar[QGLBuffer.UsagePattern] = ...
    IndexBuffer: typing.ClassVar[QGLBuffer.Type] = ...
    PixelPackBuffer: typing.ClassVar[QGLBuffer.Type] = ...
    PixelUnpackBuffer: typing.ClassVar[QGLBuffer.Type] = ...
    ReadOnly: typing.ClassVar[QGLBuffer.Access] = ...
    ReadWrite: typing.ClassVar[QGLBuffer.Access] = ...
    StaticCopy: typing.ClassVar[QGLBuffer.UsagePattern] = ...
    StaticDraw: typing.ClassVar[QGLBuffer.UsagePattern] = ...
    StaticRead: typing.ClassVar[QGLBuffer.UsagePattern] = ...
    StreamCopy: typing.ClassVar[QGLBuffer.UsagePattern] = ...
    StreamDraw: typing.ClassVar[QGLBuffer.UsagePattern] = ...
    StreamRead: typing.ClassVar[QGLBuffer.UsagePattern] = ...
    VertexBuffer: typing.ClassVar[QGLBuffer.Type] = ...
    WriteOnly: typing.ClassVar[QGLBuffer.Access] = ...
    @overload
    def __init__(self, other: QGLBuffer) -> None: ...
    @overload
    def __init__(self, type: QGLBuffer.Type) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def allocate(self, data: int, count: int = ...) -> None: ...
    @overload
    def allocate(self, count: int) -> None: ...
    def bind(self) -> bool: ...
    def bufferId(self) -> int: ...
    def create(self) -> bool: ...
    def destroy(self) -> None: ...
    def isCreated(self) -> bool: ...
    def map(self, access: QGLBuffer.Access) -> int: ...
    def read(self, offset: int, data: int, count: int) -> bool: ...
    def release(self) -> None: ...
    def setUsagePattern(self, value: QGLBuffer.UsagePattern) -> None: ...
    def size(self) -> int: ...
    def type(self) -> QGLBuffer.Type: ...
    def unmap(self) -> bool: ...
    def usagePattern(self) -> QGLBuffer.UsagePattern: ...
    def write(self, offset: int, data: int, count: int = ...) -> None: ...

class QGLColormap(shiboken2.Object):
    @overload
    def __init__(self, arg__1: QGLColormap) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def entryColor(self, idx: int) -> PySide2.QtGui.QColor: ...
    def entryRgb(self, idx: int) -> int: ...
    def find(self, color: int) -> int: ...
    def findNearest(self, color: int) -> int: ...
    def handle(self) -> int: ...
    def isEmpty(self) -> bool: ...
    @overload
    def setEntry(self, idx: int, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    @overload
    def setEntry(self, idx: int, color: int) -> None: ...
    def setHandle(self, ahandle: int) -> None: ...
    def size(self) -> int: ...
    def __copy__(self) -> None: ...

class QGLContext(shiboken2.Object):
    class BindOption:
        CanFlipNativePixmapBindOption: typing.ClassVar[QGLContext.BindOption] = ...
        DefaultBindOption: typing.ClassVar[QGLContext.BindOption] = ...
        InternalBindOption: typing.ClassVar[QGLContext.BindOption] = ...
        InvertedYBindOption: typing.ClassVar[QGLContext.BindOption] = ...
        LinearFilteringBindOption: typing.ClassVar[QGLContext.BindOption] = ...
        MemoryManagedBindOption: typing.ClassVar[QGLContext.BindOption] = ...
        MipmapBindOption: typing.ClassVar[QGLContext.BindOption] = ...
        NoBindOption: typing.ClassVar[QGLContext.BindOption] = ...
        PremultipliedAlphaBindOption: typing.ClassVar[QGLContext.BindOption] = ...
        TemporarilyCachedBindOption: typing.ClassVar[QGLContext.BindOption] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGLContext.BindOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGLContext.BindOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGLContext.BindOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QGLContext.BindOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QGLContext.BindOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGLContext.BindOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QGLContext.BindOptions: ...

    class BindOptions:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGLContext.BindOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGLContext.BindOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGLContext.BindOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QGLContext.BindOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QGLContext.BindOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGLContext.BindOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QGLContext.BindOptions: ...
    CanFlipNativePixmapBindOption: typing.ClassVar[QGLContext.BindOption] = ...
    DefaultBindOption: typing.ClassVar[QGLContext.BindOption] = ...
    InternalBindOption: typing.ClassVar[QGLContext.BindOption] = ...
    InvertedYBindOption: typing.ClassVar[QGLContext.BindOption] = ...
    LinearFilteringBindOption: typing.ClassVar[QGLContext.BindOption] = ...
    MemoryManagedBindOption: typing.ClassVar[QGLContext.BindOption] = ...
    MipmapBindOption: typing.ClassVar[QGLContext.BindOption] = ...
    NoBindOption: typing.ClassVar[QGLContext.BindOption] = ...
    PremultipliedAlphaBindOption: typing.ClassVar[QGLContext.BindOption] = ...
    TemporarilyCachedBindOption: typing.ClassVar[QGLContext.BindOption] = ...
    def __init__(self, format: QGLFormat) -> None: ...
    @classmethod
    def areSharing(cls, context1: QGLContext, context2: QGLContext) -> bool: ...
    @overload
    def bindTexture(self, image: PySide2.QtGui.QImage, target: int, format: int, options: typing.Union[QGLContext.BindOptions,QGLContext.BindOption]) -> int: ...
    @overload
    def bindTexture(self, pixmap: PySide2.QtGui.QPixmap, target: int, format: int, options: typing.Union[QGLContext.BindOptions,QGLContext.BindOption]) -> int: ...
    @overload
    def bindTexture(self, image: PySide2.QtGui.QImage, target: int = ..., format: int = ...) -> int: ...
    @overload
    def bindTexture(self, pixmap: PySide2.QtGui.QPixmap, target: int = ..., format: int = ...) -> int: ...
    @overload
    def bindTexture(self, fileName: str) -> int: ...
    def chooseContext(self, shareContext: typing.Union[QGLContext,None] = ...) -> bool: ...
    def colorIndex(self, c: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> int: ...
    def contextHandle(self) -> PySide2.QtGui.QOpenGLContext: ...
    def create(self, shareContext: typing.Union[QGLContext,None] = ...) -> bool: ...
    @classmethod
    def currentContext(cls) -> QGLContext: ...
    def deleteTexture(self, tx_id: int) -> None: ...
    def device(self) -> PySide2.QtGui.QPaintDevice: ...
    def deviceIsPixmap(self) -> bool: ...
    def doneCurrent(self) -> None: ...
    @overload
    def drawTexture(self, point: PySide2.QtCore.QPointF, textureId: int, textureTarget: int = ...) -> None: ...
    @overload
    def drawTexture(self, target: PySide2.QtCore.QRectF, textureId: int, textureTarget: int = ...) -> None: ...
    def format(self) -> QGLFormat: ...
    @classmethod
    def fromOpenGLContext(cls, platformContext: PySide2.QtGui.QOpenGLContext) -> QGLContext: ...
    def initialized(self) -> bool: ...
    def isSharing(self) -> bool: ...
    def isValid(self) -> bool: ...
    def makeCurrent(self) -> None: ...
    def moveToThread(self, thread: PySide2.QtCore.QThread) -> None: ...
    def overlayTransparentColor(self) -> PySide2.QtGui.QColor: ...
    def requestedFormat(self) -> QGLFormat: ...
    def reset(self) -> None: ...
    def setDevice(self, pDev: PySide2.QtGui.QPaintDevice) -> None: ...
    def setFormat(self, format: QGLFormat) -> None: ...
    def setInitialized(self, on: bool) -> None: ...
    @classmethod
    def setTextureCacheLimit(cls, size: int) -> None: ...
    def setValid(self, valid: bool) -> None: ...
    def setWindowCreated(self, on: bool) -> None: ...
    def swapBuffers(self) -> None: ...
    @classmethod
    def textureCacheLimit(cls) -> int: ...
    def windowCreated(self) -> bool: ...

class QGLFormat(shiboken2.Object):
    class OpenGLContextProfile:
        CompatibilityProfile: typing.ClassVar[QGLFormat.OpenGLContextProfile] = ...
        CoreProfile: typing.ClassVar[QGLFormat.OpenGLContextProfile] = ...
        NoProfile: typing.ClassVar[QGLFormat.OpenGLContextProfile] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGLFormat.OpenGLContextProfile: ...
        def __and__(self, other: typing.SupportsInt) -> QGLFormat.OpenGLContextProfile: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGLFormat.OpenGLContextProfile: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGLFormat.OpenGLContextProfile: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGLFormat.OpenGLContextProfile: ...
        def __rand__(self, other: typing.SupportsInt) -> QGLFormat.OpenGLContextProfile: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGLFormat.OpenGLContextProfile: ...
        def __ror__(self, other: typing.SupportsInt) -> QGLFormat.OpenGLContextProfile: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGLFormat.OpenGLContextProfile: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGLFormat.OpenGLContextProfile: ...
        def __sub__(self, other: typing.SupportsInt) -> QGLFormat.OpenGLContextProfile: ...
        def __xor__(self, other: typing.SupportsInt) -> QGLFormat.OpenGLContextProfile: ...

    class OpenGLVersionFlag:
        OpenGL_ES_CommonLite_Version_1_0: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
        OpenGL_ES_CommonLite_Version_1_1: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
        OpenGL_ES_Common_Version_1_0: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
        OpenGL_ES_Common_Version_1_1: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
        OpenGL_ES_Version_2_0: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
        OpenGL_Version_1_1: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
        OpenGL_Version_1_2: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
        OpenGL_Version_1_3: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
        OpenGL_Version_1_4: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
        OpenGL_Version_1_5: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
        OpenGL_Version_2_0: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
        OpenGL_Version_2_1: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
        OpenGL_Version_3_0: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
        OpenGL_Version_3_1: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
        OpenGL_Version_3_2: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
        OpenGL_Version_3_3: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
        OpenGL_Version_4_0: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
        OpenGL_Version_4_1: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
        OpenGL_Version_4_2: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
        OpenGL_Version_4_3: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
        OpenGL_Version_None: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGLFormat.OpenGLVersionFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGLFormat.OpenGLVersionFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGLFormat.OpenGLVersionFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QGLFormat.OpenGLVersionFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QGLFormat.OpenGLVersionFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGLFormat.OpenGLVersionFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QGLFormat.OpenGLVersionFlags: ...

    class OpenGLVersionFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGLFormat.OpenGLVersionFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGLFormat.OpenGLVersionFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGLFormat.OpenGLVersionFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QGLFormat.OpenGLVersionFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QGLFormat.OpenGLVersionFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGLFormat.OpenGLVersionFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QGLFormat.OpenGLVersionFlags: ...
    CompatibilityProfile: typing.ClassVar[QGLFormat.OpenGLContextProfile] = ...
    CoreProfile: typing.ClassVar[QGLFormat.OpenGLContextProfile] = ...
    NoProfile: typing.ClassVar[QGLFormat.OpenGLContextProfile] = ...
    OpenGL_ES_CommonLite_Version_1_0: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
    OpenGL_ES_CommonLite_Version_1_1: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
    OpenGL_ES_Common_Version_1_0: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
    OpenGL_ES_Common_Version_1_1: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
    OpenGL_ES_Version_2_0: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
    OpenGL_Version_1_1: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
    OpenGL_Version_1_2: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
    OpenGL_Version_1_3: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
    OpenGL_Version_1_4: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
    OpenGL_Version_1_5: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
    OpenGL_Version_2_0: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
    OpenGL_Version_2_1: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
    OpenGL_Version_3_0: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
    OpenGL_Version_3_1: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
    OpenGL_Version_3_2: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
    OpenGL_Version_3_3: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
    OpenGL_Version_4_0: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
    OpenGL_Version_4_1: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
    OpenGL_Version_4_2: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
    OpenGL_Version_4_3: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
    OpenGL_Version_None: typing.ClassVar[QGLFormat.OpenGLVersionFlag] = ...
    @overload
    def __init__(self, options: typing.Union[QGL.FormatOptions,QGL.FormatOption], plane: int = ...) -> None: ...
    @overload
    def __init__(self, other: QGLFormat) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def accum(self) -> bool: ...
    def accumBufferSize(self) -> int: ...
    def alpha(self) -> bool: ...
    def alphaBufferSize(self) -> int: ...
    def blueBufferSize(self) -> int: ...
    @classmethod
    def defaultFormat(cls) -> QGLFormat: ...
    @classmethod
    def defaultOverlayFormat(cls) -> QGLFormat: ...
    def depth(self) -> bool: ...
    def depthBufferSize(self) -> int: ...
    def directRendering(self) -> bool: ...
    def doubleBuffer(self) -> bool: ...
    @classmethod
    def fromSurfaceFormat(cls, format: PySide2.QtGui.QSurfaceFormat) -> QGLFormat: ...
    def greenBufferSize(self) -> int: ...
    @classmethod
    def hasOpenGL(cls) -> bool: ...
    @classmethod
    def hasOpenGLOverlays(cls) -> bool: ...
    def hasOverlay(self) -> bool: ...
    def majorVersion(self) -> int: ...
    def minorVersion(self) -> int: ...
    @classmethod
    def openGLVersionFlags(cls) -> typing.Union[QGLFormat.OpenGLVersionFlags,QGLFormat.OpenGLVersionFlag]: ...
    def plane(self) -> int: ...
    def profile(self) -> QGLFormat.OpenGLContextProfile: ...
    def redBufferSize(self) -> int: ...
    def rgba(self) -> bool: ...
    def sampleBuffers(self) -> bool: ...
    def samples(self) -> int: ...
    def setAccum(self, enable: bool) -> None: ...
    def setAccumBufferSize(self, size: int) -> None: ...
    def setAlpha(self, enable: bool) -> None: ...
    def setAlphaBufferSize(self, size: int) -> None: ...
    def setBlueBufferSize(self, size: int) -> None: ...
    @classmethod
    def setDefaultFormat(cls, f: QGLFormat) -> None: ...
    @classmethod
    def setDefaultOverlayFormat(cls, f: QGLFormat) -> None: ...
    def setDepth(self, enable: bool) -> None: ...
    def setDepthBufferSize(self, size: int) -> None: ...
    def setDirectRendering(self, enable: bool) -> None: ...
    def setDoubleBuffer(self, enable: bool) -> None: ...
    def setGreenBufferSize(self, size: int) -> None: ...
    def setOption(self, opt: typing.Union[QGL.FormatOptions,QGL.FormatOption]) -> None: ...
    def setOverlay(self, enable: bool) -> None: ...
    def setPlane(self, plane: int) -> None: ...
    def setProfile(self, profile: QGLFormat.OpenGLContextProfile) -> None: ...
    def setRedBufferSize(self, size: int) -> None: ...
    def setRgba(self, enable: bool) -> None: ...
    def setSampleBuffers(self, enable: bool) -> None: ...
    def setSamples(self, numSamples: int) -> None: ...
    def setStencil(self, enable: bool) -> None: ...
    def setStencilBufferSize(self, size: int) -> None: ...
    def setStereo(self, enable: bool) -> None: ...
    def setSwapInterval(self, interval: int) -> None: ...
    def setVersion(self, major: int, minor: int) -> None: ...
    def stencil(self) -> bool: ...
    def stencilBufferSize(self) -> int: ...
    def stereo(self) -> bool: ...
    def swapInterval(self) -> int: ...
    def testOption(self, opt: typing.Union[QGL.FormatOptions,QGL.FormatOption]) -> bool: ...
    @classmethod
    def toSurfaceFormat(cls, format: QGLFormat) -> PySide2.QtGui.QSurfaceFormat: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QGLFramebufferObject(PySide2.QtGui.QPaintDevice):
    class Attachment:
        CombinedDepthStencil: typing.ClassVar[QGLFramebufferObject.Attachment] = ...
        Depth: typing.ClassVar[QGLFramebufferObject.Attachment] = ...
        NoAttachment: typing.ClassVar[QGLFramebufferObject.Attachment] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGLFramebufferObject.Attachment: ...
        def __and__(self, other: typing.SupportsInt) -> QGLFramebufferObject.Attachment: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGLFramebufferObject.Attachment: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGLFramebufferObject.Attachment: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGLFramebufferObject.Attachment: ...
        def __rand__(self, other: typing.SupportsInt) -> QGLFramebufferObject.Attachment: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGLFramebufferObject.Attachment: ...
        def __ror__(self, other: typing.SupportsInt) -> QGLFramebufferObject.Attachment: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGLFramebufferObject.Attachment: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGLFramebufferObject.Attachment: ...
        def __sub__(self, other: typing.SupportsInt) -> QGLFramebufferObject.Attachment: ...
        def __xor__(self, other: typing.SupportsInt) -> QGLFramebufferObject.Attachment: ...
    CombinedDepthStencil: typing.ClassVar[QGLFramebufferObject.Attachment] = ...
    Depth: typing.ClassVar[QGLFramebufferObject.Attachment] = ...
    NoAttachment: typing.ClassVar[QGLFramebufferObject.Attachment] = ...
    @overload
    def __init__(self, width: int, height: int, attachment: QGLFramebufferObject.Attachment, target: int = ..., internal_format: int = ...) -> None: ...
    @overload
    def __init__(self, size: PySide2.QtCore.QSize, attachment: QGLFramebufferObject.Attachment, target: int = ..., internal_format: int = ...) -> None: ...
    @overload
    def __init__(self, width: int, height: int, format: QGLFramebufferObjectFormat) -> None: ...
    @overload
    def __init__(self, width: int, height: int, target: int = ...) -> None: ...
    @overload
    def __init__(self, size: PySide2.QtCore.QSize, format: QGLFramebufferObjectFormat) -> None: ...
    @overload
    def __init__(self, size: PySide2.QtCore.QSize, target: int = ...) -> None: ...
    def attachment(self) -> QGLFramebufferObject.Attachment: ...
    def bind(self) -> bool: ...
    @classmethod
    def bindDefault(cls) -> bool: ...
    @classmethod
    def blitFramebuffer(cls, target: QGLFramebufferObject, targetRect: PySide2.QtCore.QRect, source: QGLFramebufferObject, sourceRect: PySide2.QtCore.QRect, buffers: int = ..., filter: int = ...) -> None: ...
    def devType(self) -> int: ...
    @overload
    def drawTexture(self, point: PySide2.QtCore.QPointF, textureId: int, textureTarget: int = ...) -> None: ...
    @overload
    def drawTexture(self, target: PySide2.QtCore.QRectF, textureId: int, textureTarget: int = ...) -> None: ...
    def format(self) -> QGLFramebufferObjectFormat: ...
    def handle(self) -> int: ...
    @classmethod
    def hasOpenGLFramebufferBlit(cls) -> bool: ...
    @classmethod
    def hasOpenGLFramebufferObjects(cls) -> bool: ...
    def isBound(self) -> bool: ...
    def isValid(self) -> bool: ...
    def metric(self, metric: PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEngine(self) -> PySide2.QtGui.QPaintEngine: ...
    def release(self) -> bool: ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def texture(self) -> int: ...
    def toImage(self) -> PySide2.QtGui.QImage: ...

class QGLFramebufferObjectFormat(shiboken2.Object):
    @overload
    def __init__(self, other: QGLFramebufferObjectFormat) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def attachment(self) -> QGLFramebufferObject.Attachment: ...
    def internalTextureFormat(self) -> int: ...
    def mipmap(self) -> bool: ...
    def samples(self) -> int: ...
    def setAttachment(self, attachment: QGLFramebufferObject.Attachment) -> None: ...
    def setInternalTextureFormat(self, internalTextureFormat: int) -> None: ...
    def setMipmap(self, enabled: bool) -> None: ...
    def setSamples(self, samples: int) -> None: ...
    def setTextureTarget(self, target: int) -> None: ...
    def textureTarget(self) -> int: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QGLPixelBuffer(PySide2.QtGui.QPaintDevice):
    @overload
    def __init__(self, width: int, height: int, format: QGLFormat = ..., shareWidget: typing.Union[QGLWidget,None] = ...) -> None: ...
    @overload
    def __init__(self, size: PySide2.QtCore.QSize, format: QGLFormat = ..., shareWidget: typing.Union[QGLWidget,None] = ...) -> None: ...
    @overload
    def bindTexture(self, image: PySide2.QtGui.QImage, target: int = ...) -> int: ...
    @overload
    def bindTexture(self, pixmap: PySide2.QtGui.QPixmap, target: int = ...) -> int: ...
    @overload
    def bindTexture(self, fileName: str) -> int: ...
    def bindToDynamicTexture(self, texture: int) -> bool: ...
    def context(self) -> QGLContext: ...
    def deleteTexture(self, texture_id: int) -> None: ...
    def devType(self) -> int: ...
    def doneCurrent(self) -> bool: ...
    @overload
    def drawTexture(self, point: PySide2.QtCore.QPointF, textureId: int, textureTarget: int = ...) -> None: ...
    @overload
    def drawTexture(self, target: PySide2.QtCore.QRectF, textureId: int, textureTarget: int = ...) -> None: ...
    def format(self) -> QGLFormat: ...
    def generateDynamicTexture(self) -> int: ...
    def handle(self) -> int: ...
    @classmethod
    def hasOpenGLPbuffers(cls) -> bool: ...
    def isValid(self) -> bool: ...
    def makeCurrent(self) -> bool: ...
    def metric(self, metric: PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEngine(self) -> PySide2.QtGui.QPaintEngine: ...
    def releaseFromDynamicTexture(self) -> None: ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def toImage(self) -> PySide2.QtGui.QImage: ...
    def updateDynamicTexture(self, texture_id: int) -> None: ...

class QGLShader(PySide2.QtCore.QObject):
    class ShaderType:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGLShader.ShaderType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGLShader.ShaderType: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGLShader.ShaderType: ...
        def __rand__(self, other: typing.SupportsInt) -> QGLShader.ShaderType: ...
        def __ror__(self, other: typing.SupportsInt) -> QGLShader.ShaderType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGLShader.ShaderType: ...
        def __xor__(self, other: typing.SupportsInt) -> QGLShader.ShaderType: ...

    class ShaderTypeBit:
        Fragment: typing.ClassVar[QGLShader.ShaderTypeBit] = ...
        Geometry: typing.ClassVar[QGLShader.ShaderTypeBit] = ...
        Vertex: typing.ClassVar[QGLShader.ShaderTypeBit] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGLShader.ShaderType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGLShader.ShaderType: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGLShader.ShaderType: ...
        def __rand__(self, other: typing.SupportsInt) -> QGLShader.ShaderType: ...
        def __ror__(self, other: typing.SupportsInt) -> QGLShader.ShaderType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGLShader.ShaderType: ...
        def __xor__(self, other: typing.SupportsInt) -> QGLShader.ShaderType: ...
    Fragment: typing.ClassVar[QGLShader.ShaderTypeBit] = ...
    Geometry: typing.ClassVar[QGLShader.ShaderTypeBit] = ...
    Vertex: typing.ClassVar[QGLShader.ShaderTypeBit] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, type: typing.Union[QGLShader.ShaderType,QGLShader.ShaderTypeBit], context: QGLContext, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, type: typing.Union[QGLShader.ShaderType,QGLShader.ShaderTypeBit], parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @overload
    def compileSourceCode(self, source: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> bool: ...
    @overload
    def compileSourceCode(self, source: str) -> bool: ...
    @overload
    def compileSourceCode(self, source: bytes) -> bool: ...
    def compileSourceFile(self, fileName: str) -> bool: ...
    @classmethod
    def hasOpenGLShaders(cls, type: typing.Union[QGLShader.ShaderType,QGLShader.ShaderTypeBit], context: typing.Union[QGLContext,None] = ...) -> bool: ...
    def isCompiled(self) -> bool: ...
    def log(self) -> str: ...
    def shaderId(self) -> int: ...
    def shaderType(self) -> typing.Union[QGLShader.ShaderType,QGLShader.ShaderTypeBit]: ...
    def sourceCode(self) -> PySide2.QtCore.QByteArray: ...

class QGLShaderProgram(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, context: QGLContext, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def addShader(self, shader: QGLShader) -> bool: ...
    @overload
    def addShaderFromSourceCode(self, type: typing.Union[QGLShader.ShaderType,QGLShader.ShaderTypeBit], source: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> bool: ...
    @overload
    def addShaderFromSourceCode(self, type: typing.Union[QGLShader.ShaderType,QGLShader.ShaderTypeBit], source: str) -> bool: ...
    @overload
    def addShaderFromSourceCode(self, type: typing.Union[QGLShader.ShaderType,QGLShader.ShaderTypeBit], source: bytes) -> bool: ...
    def addShaderFromSourceFile(self, type: typing.Union[QGLShader.ShaderType,QGLShader.ShaderTypeBit], fileName: str) -> bool: ...
    @overload
    def attributeLocation(self, name: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> int: ...
    @overload
    def attributeLocation(self, name: str) -> int: ...
    @overload
    def attributeLocation(self, name: bytes) -> int: ...
    def bind(self) -> bool: ...
    @overload
    def bindAttributeLocation(self, name: typing.Union[PySide2.QtCore.QByteArray,bytes], location: int) -> None: ...
    @overload
    def bindAttributeLocation(self, name: str, location: int) -> None: ...
    @overload
    def bindAttributeLocation(self, name: bytes, location: int) -> None: ...
    @overload
    def disableAttributeArray(self, location: int) -> None: ...
    @overload
    def disableAttributeArray(self, name: bytes) -> None: ...
    @overload
    def enableAttributeArray(self, location: int) -> None: ...
    @overload
    def enableAttributeArray(self, name: bytes) -> None: ...
    def geometryInputType(self) -> int: ...
    def geometryOutputType(self) -> int: ...
    def geometryOutputVertexCount(self) -> int: ...
    @classmethod
    def hasOpenGLShaderPrograms(cls, context: typing.Union[QGLContext,None] = ...) -> bool: ...
    def isLinked(self) -> bool: ...
    def link(self) -> bool: ...
    def log(self) -> str: ...
    def maxGeometryOutputVertices(self) -> int: ...
    def programId(self) -> int: ...
    def release(self) -> None: ...
    def removeAllShaders(self) -> None: ...
    def removeShader(self, shader: QGLShader) -> None: ...
    @overload
    def setAttributeArray2D(self, location: int, values: PySide2.QtGui.QVector2D, stride: int = ...) -> None: ...
    @overload
    def setAttributeArray2D(self, name: bytes, values: PySide2.QtGui.QVector2D, stride: int = ...) -> None: ...
    @overload
    def setAttributeArray3D(self, location: int, values: PySide2.QtGui.QVector3D, stride: int = ...) -> None: ...
    @overload
    def setAttributeArray3D(self, name: bytes, values: PySide2.QtGui.QVector3D, stride: int = ...) -> None: ...
    @overload
    def setAttributeArray4D(self, location: int, values: PySide2.QtGui.QVector4D, stride: int = ...) -> None: ...
    @overload
    def setAttributeArray4D(self, name: bytes, values: PySide2.QtGui.QVector4D, stride: int = ...) -> None: ...
    @overload
    def setAttributeBuffer(self, location: int, type: int, offset: int, tupleSize: int, stride: int = ...) -> None: ...
    @overload
    def setAttributeBuffer(self, name: bytes, type: int, offset: int, tupleSize: int, stride: int = ...) -> None: ...
    @overload
    def setAttributeValue(self, location: int, x: float, y: float, z: float, w: float) -> None: ...
    @overload
    def setAttributeValue(self, name: bytes, x: float, y: float, z: float, w: float) -> None: ...
    @overload
    def setAttributeValue(self, location: int, x: float, y: float, z: float) -> None: ...
    @overload
    def setAttributeValue(self, name: bytes, x: float, y: float, z: float) -> None: ...
    @overload
    def setAttributeValue(self, location: int, x: float, y: float) -> None: ...
    @overload
    def setAttributeValue(self, name: bytes, x: float, y: float) -> None: ...
    @overload
    def setAttributeValue(self, location: int, value: float) -> None: ...
    @overload
    def setAttributeValue(self, location: int, value: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    @overload
    def setAttributeValue(self, location: int, value: PySide2.QtGui.QVector2D) -> None: ...
    @overload
    def setAttributeValue(self, location: int, value: PySide2.QtGui.QVector3D) -> None: ...
    @overload
    def setAttributeValue(self, location: int, value: PySide2.QtGui.QVector4D) -> None: ...
    @overload
    def setAttributeValue(self, name: bytes, value: float) -> None: ...
    @overload
    def setAttributeValue(self, name: bytes, value: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    @overload
    def setAttributeValue(self, name: bytes, value: PySide2.QtGui.QVector2D) -> None: ...
    @overload
    def setAttributeValue(self, name: bytes, value: PySide2.QtGui.QVector3D) -> None: ...
    @overload
    def setAttributeValue(self, name: bytes, value: PySide2.QtGui.QVector4D) -> None: ...
    def setGeometryInputType(self, inputType: int) -> None: ...
    def setGeometryOutputType(self, outputType: int) -> None: ...
    def setGeometryOutputVertexCount(self, count: int) -> None: ...
    @overload
    def setUniformValue(self, location: int, x: float, y: float, z: float, w: float) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, x: float, y: float, z: float, w: float) -> None: ...
    @overload
    def setUniformValue(self, location: int, x: float, y: float, z: float) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, x: float, y: float, z: float) -> None: ...
    @overload
    def setUniformValue(self, location: int, x: float, y: float) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, x: float, y: float) -> None: ...
    @overload
    def setUniformValue(self, location: int, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    @overload
    def setUniformValue(self, location: int, point: PySide2.QtCore.QPoint) -> None: ...
    @overload
    def setUniformValue(self, location: int, point: PySide2.QtCore.QPointF) -> None: ...
    @overload
    def setUniformValue(self, location: int, size: PySide2.QtCore.QSize) -> None: ...
    @overload
    def setUniformValue(self, location: int, size: PySide2.QtCore.QSizeF) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: float) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: int) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: PySide2.QtGui.QMatrix2x2) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: PySide2.QtGui.QMatrix2x3) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: PySide2.QtGui.QMatrix2x4) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: PySide2.QtGui.QMatrix3x2) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: PySide2.QtGui.QMatrix3x3) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: PySide2.QtGui.QMatrix3x4) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: PySide2.QtGui.QMatrix4x2) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: PySide2.QtGui.QMatrix4x3) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: PySide2.QtGui.QMatrix4x4) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: PySide2.QtGui.QTransform) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: PySide2.QtGui.QVector2D) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: PySide2.QtGui.QVector3D) -> None: ...
    @overload
    def setUniformValue(self, location: int, value: PySide2.QtGui.QVector4D) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, color: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, point: PySide2.QtCore.QPoint) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, point: PySide2.QtCore.QPointF) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, size: PySide2.QtCore.QSize) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, size: PySide2.QtCore.QSizeF) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, value: float) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, value: int) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, value: PySide2.QtGui.QMatrix2x2) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, value: PySide2.QtGui.QMatrix2x3) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, value: PySide2.QtGui.QMatrix2x4) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, value: PySide2.QtGui.QMatrix3x2) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, value: PySide2.QtGui.QMatrix3x3) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, value: PySide2.QtGui.QMatrix3x4) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, value: PySide2.QtGui.QMatrix4x2) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, value: PySide2.QtGui.QMatrix4x3) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, value: PySide2.QtGui.QMatrix4x4) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, value: PySide2.QtGui.QTransform) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, value: PySide2.QtGui.QVector2D) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, value: PySide2.QtGui.QVector3D) -> None: ...
    @overload
    def setUniformValue(self, name: bytes, value: PySide2.QtGui.QVector4D) -> None: ...
    @overload
    def setUniformValueArray2D(self, location: int, values: PySide2.QtGui.QVector2D, count: int) -> None: ...
    @overload
    def setUniformValueArray2D(self, name: bytes, values: PySide2.QtGui.QVector2D, count: int) -> None: ...
    @overload
    def setUniformValueArray2x2(self, location: int, values: PySide2.QtGui.QMatrix2x2, count: int) -> None: ...
    @overload
    def setUniformValueArray2x2(self, name: bytes, values: PySide2.QtGui.QMatrix2x2, count: int) -> None: ...
    @overload
    def setUniformValueArray2x3(self, location: int, values: PySide2.QtGui.QMatrix2x3, count: int) -> None: ...
    @overload
    def setUniformValueArray2x3(self, name: bytes, values: PySide2.QtGui.QMatrix2x3, count: int) -> None: ...
    @overload
    def setUniformValueArray2x4(self, location: int, values: PySide2.QtGui.QMatrix2x4, count: int) -> None: ...
    @overload
    def setUniformValueArray2x4(self, name: bytes, values: PySide2.QtGui.QMatrix2x4, count: int) -> None: ...
    @overload
    def setUniformValueArray3D(self, location: int, values: PySide2.QtGui.QVector3D, count: int) -> None: ...
    @overload
    def setUniformValueArray3D(self, name: bytes, values: PySide2.QtGui.QVector3D, count: int) -> None: ...
    @overload
    def setUniformValueArray3x2(self, location: int, values: PySide2.QtGui.QMatrix3x2, count: int) -> None: ...
    @overload
    def setUniformValueArray3x2(self, name: bytes, values: PySide2.QtGui.QMatrix3x2, count: int) -> None: ...
    @overload
    def setUniformValueArray3x3(self, location: int, values: PySide2.QtGui.QMatrix3x3, count: int) -> None: ...
    @overload
    def setUniformValueArray3x3(self, name: bytes, values: PySide2.QtGui.QMatrix3x3, count: int) -> None: ...
    @overload
    def setUniformValueArray3x4(self, location: int, values: PySide2.QtGui.QMatrix3x4, count: int) -> None: ...
    @overload
    def setUniformValueArray3x4(self, name: bytes, values: PySide2.QtGui.QMatrix3x4, count: int) -> None: ...
    @overload
    def setUniformValueArray4D(self, location: int, values: PySide2.QtGui.QVector4D, count: int) -> None: ...
    @overload
    def setUniformValueArray4D(self, name: bytes, values: PySide2.QtGui.QVector4D, count: int) -> None: ...
    @overload
    def setUniformValueArray4x2(self, location: int, values: PySide2.QtGui.QMatrix4x2, count: int) -> None: ...
    @overload
    def setUniformValueArray4x2(self, name: bytes, values: PySide2.QtGui.QMatrix4x2, count: int) -> None: ...
    @overload
    def setUniformValueArray4x3(self, location: int, values: PySide2.QtGui.QMatrix4x3, count: int) -> None: ...
    @overload
    def setUniformValueArray4x3(self, name: bytes, values: PySide2.QtGui.QMatrix4x3, count: int) -> None: ...
    @overload
    def setUniformValueArray4x4(self, location: int, values: PySide2.QtGui.QMatrix4x4, count: int) -> None: ...
    @overload
    def setUniformValueArray4x4(self, name: bytes, values: PySide2.QtGui.QMatrix4x4, count: int) -> None: ...
    @overload
    def setUniformValueArrayInt(self, location: int, values: typing.Iterable[int], count: int) -> None: ...
    @overload
    def setUniformValueArrayInt(self, name: bytes, values: typing.Iterable[int], count: int) -> None: ...
    @overload
    def setUniformValueArrayUint(self, location: int, values: typing.Iterable[int], count: int) -> None: ...
    @overload
    def setUniformValueArrayUint(self, name: bytes, values: typing.Iterable[int], count: int) -> None: ...
    def shaders(self) -> typing.List[QGLShader]: ...
    @overload
    def uniformLocation(self, name: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> int: ...
    @overload
    def uniformLocation(self, name: str) -> int: ...
    @overload
    def uniformLocation(self, name: bytes) -> int: ...

class QGLWidget(PySide2.QtWidgets.QWidget):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, context: QGLContext, parent: typing.Union[PySide2.QtWidgets.QWidget,None] = ..., shareWidget: typing.Union[QGLWidget,None] = ..., f: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: PySide2.QtWidgets.QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, format: QGLFormat, parent: typing.Union[PySide2.QtWidgets.QWidget,None] = ..., shareWidget: typing.Union[QGLWidget,None] = ..., f: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: PySide2.QtWidgets.QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[PySide2.QtWidgets.QWidget,None] = ..., shareWidget: typing.Union[QGLWidget,None] = ..., f: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: PySide2.QtWidgets.QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def autoBufferSwap(self) -> bool: ...
    @overload
    def bindTexture(self, image: PySide2.QtGui.QImage, target: int, format: int, options: typing.Union[QGLContext.BindOptions,QGLContext.BindOption]) -> int: ...
    @overload
    def bindTexture(self, pixmap: PySide2.QtGui.QPixmap, target: int, format: int, options: typing.Union[QGLContext.BindOptions,QGLContext.BindOption]) -> int: ...
    @overload
    def bindTexture(self, image: PySide2.QtGui.QImage, target: int = ..., format: int = ...) -> int: ...
    @overload
    def bindTexture(self, pixmap: PySide2.QtGui.QPixmap, target: int = ..., format: int = ...) -> int: ...
    @overload
    def bindTexture(self, fileName: str) -> int: ...
    def colormap(self) -> QGLColormap: ...
    def context(self) -> QGLContext: ...
    @classmethod
    def convertToGLFormat(cls, img: PySide2.QtGui.QImage) -> PySide2.QtGui.QImage: ...
    def deleteTexture(self, tx_id: int) -> None: ...
    def doneCurrent(self) -> None: ...
    def doubleBuffer(self) -> bool: ...
    @overload
    def drawTexture(self, point: PySide2.QtCore.QPointF, textureId: int, textureTarget: int = ...) -> None: ...
    @overload
    def drawTexture(self, target: PySide2.QtCore.QRectF, textureId: int, textureTarget: int = ...) -> None: ...
    def event(self, arg__1: PySide2.QtCore.QEvent) -> bool: ...
    def format(self) -> QGLFormat: ...
    def glDraw(self) -> None: ...
    def glInit(self) -> None: ...
    def grabFrameBuffer(self, withAlpha: bool = ...) -> PySide2.QtGui.QImage: ...
    def initializeGL(self) -> None: ...
    def initializeOverlayGL(self) -> None: ...
    def isSharing(self) -> bool: ...
    def isValid(self) -> bool: ...
    def makeCurrent(self) -> None: ...
    def makeOverlayCurrent(self) -> None: ...
    def overlayContext(self) -> QGLContext: ...
    def paintEngine(self) -> PySide2.QtGui.QPaintEngine: ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent) -> None: ...
    def paintGL(self) -> None: ...
    def paintOverlayGL(self) -> None: ...
    def qglClearColor(self, c: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    def qglColor(self, c: typing.Union[PySide2.QtGui.QColor,PySide2.QtCore.Qt.GlobalColor,int]) -> None: ...
    def renderPixmap(self, w: int = ..., h: int = ..., useContext: bool = ...) -> PySide2.QtGui.QPixmap: ...
    @overload
    def renderText(self, x: float, y: float, z: float, str: str, fnt: PySide2.QtGui.QFont = ...) -> None: ...
    @overload
    def renderText(self, x: int, y: int, str: str, fnt: PySide2.QtGui.QFont = ...) -> None: ...
    def resizeEvent(self, arg__1: PySide2.QtGui.QResizeEvent) -> None: ...
    def resizeGL(self, w: int, h: int) -> None: ...
    def resizeOverlayGL(self, w: int, h: int) -> None: ...
    def setAutoBufferSwap(self, on: bool) -> None: ...
    def setColormap(self, map: QGLColormap) -> None: ...
    def swapBuffers(self) -> None: ...
    def updateGL(self) -> None: ...
    def updateOverlayGL(self) -> None: ...
