from math import cos, sin, radians, sqrt


class Utils:
    @staticmethod
    def turn(a, p):
        r = radians(a)
        xr = p.x * cos(r) + p.y * sin(r)
        yr = - p.x * sin(r) + p.y * cos(r)
        return Point(round(xr, 2), round(yr, 2), p.type)


class Point:
    def __init__(self, x=0.0, y=0.0, type_=None):
        self.type = type_
        self.x = x
        self.y = y

    def set_y_increase(self, value):
        self.y = self.y - value if self.y < 0 else self.y + value

    @staticmethod
    def z():
        return Point(type_="Z")

    def turn(self, angl):
        return Utils.turn(angl, self)


class Path:
    """ Для генерации Path """

    def __init__(self, points=None):
        if points is None:
            points = []
        self.path = points

    def l(self, x, y):
        self.path.append(Point(x, y, "L"))

    def m(self, x, y):
        if len(self.path) > 0 and self.path[-1].type == "M":
            self.path[-1].x = x
            self.path[-1].y = y
        else:
            self.path.append(Point(x, y, "M"))

    def z(self):
        self.path.append(Point(type_="Z"))

    def add(self, path):
        for p in path.path:
            if p.type == "M":
                self.m(p.x, p.y)
            elif p.type == "Z":
                self.z()
            elif p.type == "L":
                self.l(p.x, p.y)
            else:
                raise NotImplementedError(p.type)

    def __str__(self):
        result = ""
        for c in self.path:
            result += "{c} {x} {y} ".format(c=c.type, x=c.x, y=c.y) if c.type != "Z" else "Z "
        return result

    def is_empty(self):
        return len(self.path) == 0

    def min_x(self):
        """ минимвльный x без первого """
        if self.is_empty():
            return 0
        p = [x for x in self.path if x.type != 'Z']
        max_x = min(p[1:] if p[0].type == 'М' else p, key=lambda item: item.x)
        return max_x.x

    def max_x(self):
        if self.is_empty():
            return 0
        max_x = max(self.path, key=lambda item: item.x)
        return max_x.x

    def delta_x(self):
        return self.max_x() - self.min_x()

    def move_x(self, v):
        return Path(map(lambda p: Point(p.x + v, p.y, p.type), self.path))

    def turn(self, a):
        return Path(map(lambda p: p.turn(a), self.path))

    def y_offset(self):
        if self.is_empty():
            return 0
        ps = [p for p in self.path if p.type != 'Z']
        result = set(map(lambda p: p.y, ps))
        assert len(result) == 1  # do not call this method if not satisfied this condition
        return list(result)[0] * -1


class AxAngl:
    """ Логика для рисования ломаных >< ANGLE_TICK"""

    def __init__(self, top, bottom, pos_x):
        self.pos_x = pos_x if pos_x == 0 else pos_x + 0.5
        self.top = top
        self.bottom = bottom

    # >
    def angl_right_path(self):
        return self.to_path().move_x(self.pos_x)

    # <
    def angl_left_path(self):
        return self.to_path().turn(180).move_x(self.pos_x)

    def to_path(self):
        if self.top == 1 and self.bottom == 0:  # точка
            return Path([Point(-0.5, 0, "M"), Point(0.5, 0, "L"), Point.z()])
        if self.top == 0:  # наклонная линия / от 0.5 по y
            return Path(
                [Point(0, (self.bottom + 0.5) * sqrt(2), "M").turn(-45),
                 Point(0, 0.5 * sqrt(2), "L").turn(-45), Point.z()])
        if self.top == 1 and self.bottom > 0:  # наклонная линия /
            return Path([Point(0, (self.bottom + 0.5) * sqrt(2), "M").turn(-45),
                         Point(0, -0.5 * sqrt(2), "L").turn(-45), Point.z()])
        if self.bottom == 0 and self.top > 1:  # наклонная линия \
            return Path(
                [Point(0, 0.5 * sqrt(2), "M").turn(45), Point(0, ((self.top - 0.5) * sqrt(2)) * -1, "L").turn(45),
                 Point.z()])
        # >  0.2 тут для сглаживания
        return Path([
            Point(0, (self.bottom + 0.5) * sqrt(2), "M").turn(-45), Point(0, -0.2 * sqrt(2), "L").turn(-45), Point.z(),
            Point(0, 0.2 * sqrt(2), "M").turn(45), Point(0, ((self.top - 0.5) * sqrt(2)) * -1, "L").turn(45), Point.z()
        ])


class AxPolygon:
    """Полигон"""

    def __init__(self, path):
        self.path = path

    def scale(self, k=2):
        for p in self.path.path:
            p.x = p.x * k
            p.y = p.y * k


class AxTick:
    """ Вертикальная линия TICK_MARK """

    def __init__(self, top, bottom, pos_x):
        self.top = top
        self.bottom = bottom
        self.pos_x = pos_x

    def make_points(self):
        if self.bottom == 0:
            return [Point(0, (self.top + 0.5) * -1, "M"), Point(0, -0.5, "L"), Point.z()]
        elif self.bottom == 1:
            return [Point(0, (self.top + 0.5) * -1, "M"), Point(0, 0.5, "L"), Point.z()]
        else:
            return [Point(0, (self.top + 0.5) * -1, "M"), Point(0, self.bottom - 0.5, "L"), Point.z()]

    def tick_path(self):
        """|"""
        return Path(self.make_points()).move_x(self.pos_x + 0.5)
