import os

from .pen.mipen import MIPenParser
from .pen.mipen2axioma import Utils


def convert(input_file, output_dir):
    pen_parser = MIPenParser(input_file)

    # convert all pens
    count = len(pen_parser.pens)
    for i in range(1, count):
        save_pen(pen_parser, i, output_dir)


def save_pen(pen_parser, index, output_dir):
    """
    сохранение файла trtp-pen в текстовый файл
        i - порядковый номер pen'а
    """
    file_name = "pen_{}.trtp".format('{:03d}'.format(index))
    file_path = os.path.join(output_dir, file_name)
    with open(file_path, 'w') as f:
        f.write(Utils.convert(pen_parser.pens[index]))
    return file_path
