from .context import Context as Context
from .label import CustomLabelEndType as CustomLabelEndType, CustomLabelProperties as CustomLabelProperties
from .layer import CosmeticLayer as CosmeticLayer, Layer as Layer, VectorLayer as VectorLayer
from PySide2.QtCore import Signal as Signal
from PySide2.QtGui import QImage
from axipy.cpp_render import ShadowLayer as ShadowLayer, ShadowLayers as ShadowLayers, ShadowMap as ShadowMap
from axipy.cs import AreaUnit as AreaUnit, CoordSystem as CoordSystem, LinearUnit as LinearUnit
from axipy.utl import Rect as Rect
from typing import List, Optional, Union

class ListLayers:
    def __init__(self) -> None: ...
    @property
    def count(self) -> int: ...
    def __len__(self) -> int: ...
    def __iter__(self): ...
    def at(self, index: int) -> Union[Layer, 'ListLayers']: ...
    def __getitem__(self, index: Union[int, str]) -> Union[Layer, 'ListLayers']: ...
    @property
    def title(self) -> str: ...
    @title.setter
    def title(self, n: str): ...
    def append(self, layer: Layer): ...
    def add(self, layer: Layer): ...
    def remove(self, index: int): ...
    def move(self, from_index: int, to_index: int): ...
    def group(self, indexes: List[int], name: str): ...
    def ungroup(self, index: int): ...
    def add_group(self, name: str): ...
    @property
    def visible(self): ...
    @visible.setter
    def visible(self, v) -> None: ...

class CustomLabels:
    def __init__(self) -> None: ...
    def set(self, layer: VectorLayer, id: int, properties: Optional[CustomLabelProperties]): ...
    def get(self, layer: VectorLayer, id: int) -> Optional[CustomLabelProperties]: ...

class Map:
    def __init__(self, layers: List[Layer] = ...) -> None: ...
    @property
    def need_redraw(self) -> Signal: ...
    def draw(self, context: Context): ...
    def get_best_coordsystem(self) -> CoordSystem: ...
    def get_best_rect(self, coordsystem: CoordSystem = ...) -> Rect: ...
    @property
    def distanceUnit(self) -> LinearUnit: ...
    @distanceUnit.setter
    def distanceUnit(self, unit: LinearUnit): ...
    @property
    def areaUnit(self) -> AreaUnit: ...
    @areaUnit.setter
    def areaUnit(self, u: AreaUnit): ...
    @property
    def layers(self) -> ListLayers: ...
    @property
    def custom_labels(self) -> CustomLabels: ...
    @property
    def editable_layer(self) -> VectorLayer: ...
    @editable_layer.setter
    def editable_layer(self, layer: Optional[VectorLayer]): ...
    @property
    def cosmetic(self) -> CosmeticLayer: ...
    def __eq__(self, other): ...
    def __contains__(self, layer: Layer): ...
    def to_image(self, width: int, height: int, coordsystem: CoordSystem = ..., bbox: Rect = ...) -> QImage: ...
