from .view import MapView, View
from PySide2.QtCore import QEvent, QObject, QPoint, QPointF, QRect, QRectF, Qt
from PySide2.QtGui import QCursor, QKeyEvent, QMouseEvent, QPaintEvent, QPainter, QWheelEvent
from _typeshed import Incomplete
from axipy.cpp_gui import InteractionType, ShadowMapTool as ShadowTool
from axipy.da import Observer
from axipy.utl import Pnt, Rect
from enum import Enum
from typing import Optional, Union

class DeactivationReason(Enum):
    Unknown: int
    ObjectClose: int
    WindowClose: int
    ActionClick: int
    ActionShortcut: int
    LayerClick: int

class MapTool(ShadowTool):
    PassEvent: bool
    BlockEvent: bool
    enable_on: Union[str, Observer]
    @property
    def view(self) -> MapView: ...
    def to_scene(self, device: Union[QPoint, QRect]) -> Union[Pnt, Rect]: ...
    def to_device(self, scene: Union[Pnt, Rect]) -> Union[QPoint, QRect]: ...
    def get_select_rect(self, device: QPoint, size: int = ...) -> Rect: ...
    def redraw(self) -> None: ...
    def is_snapped(self) -> bool: ...
    def snap(self, default_value: Pnt = ...) -> Optional[Pnt]: ...
    def snap_device(self, default_value: QPoint = ...) -> Optional[QPoint]: ...
    def handleEvent_impl(self, event: QEvent) -> bool: ...
    def handleEvent(self, event: QEvent) -> Optional[bool]: ...
    def paintEvent(self, event: QPaintEvent, painter: QPainter): ...
    def mousePressEvent_impl(self, event: QEvent) -> bool: ...
    def mouseReleaseEvent_impl(self, event: QEvent) -> bool: ...
    def mouseDoubleClickEvent_impl(self, event: QEvent) -> bool: ...
    def mouseMoveEvent_impl(self, event: QEvent) -> bool: ...
    def keyPressEvent_impl(self, event: QEvent) -> bool: ...
    def keyReleaseEvent_impl(self, event: QEvent) -> bool: ...
    def wheelEvent_impl(self, event: QEvent) -> bool: ...
    def mousePressEvent(self, event: QMouseEvent) -> Optional[bool]: ...
    def mouseReleaseEvent(self, event: QMouseEvent) -> Optional[bool]: ...
    def mouseDoubleClickEvent(self, event: QMouseEvent) -> Optional[bool]: ...
    def mouseMoveEvent(self, event: QMouseEvent) -> Optional[bool]: ...
    def keyPressEvent(self, event: QKeyEvent) -> Optional[bool]: ...
    def keyReleaseEvent(self, event: QKeyEvent) -> Optional[bool]: ...
    def wheelEvent(self, event: QWheelEvent) -> Optional[bool]: ...
    def unload(self) -> None: ...
    def deactivate(self) -> None: ...
    def deactivate_impl(self) -> None: ...
    def load(self) -> None: ...
    def onActivate_impl(self) -> None: ...
    def canUnload(self, reason: DeactivationReason) -> bool: ...
    def canDeactivate(self, reason: DeactivationReason) -> bool: ...
    def canDeactivate_impl(self, reason: InteractionType) -> bool: ...
    @staticmethod
    def reset() -> None: ...
    @property
    def cursor(self) -> QCursor: ...
    @cursor.setter
    def cursor(self, v: QCursor): ...

class ViewPointsHelper:
    def __init__(self, view) -> None: ...
    def normalize_point(self, point: Union[Pnt, QPoint, QPointF]) -> QPointF: ...

class SelectToolBehavior(QObject):
    def __init__(self, tool: MapTool) -> None: ...
    def mousePressEvent(self, event: QMouseEvent) -> bool: ...
    def mouseMoveEvent(self, event: QMouseEvent) -> bool: ...
    def paintEvent(self, event: QPaintEvent, painter: QPainter): ...
    def mouseReleaseEvent(self, event: QMouseEvent) -> bool: ...
    def keyPressEvent(self, event: QKeyEvent) -> bool: ...

class SelectToolHelpers:
    class _ShadowDesc:
        def __init__(self) -> None: ...
        def __get__(self, obj, objtype: Incomplete | None = ...): ...
    @classmethod
    def select_by_mouse(cls, view: View, event: QMouseEvent): ...
    @classmethod
    def select_by_rect(cls, view: View, rect: Union[QRectF, Rect], modifiers: Qt.KeyboardModifiers): ...
