from .csv_data_provider import CsvDataProvider
from .data_provider import DataProvider
from .excel_data_provider import ExcelDataProvider
from .gdal_data_provider import GdalDataProvider
from .mif_data_provider import MifMidDataProvider
from .mssql_data_provider import MsSqlDataProvider
from .ogr_data_provider import OgrDataProvider
from .oracle_data_provider import OracleDataProvider
from .postgre_data_provider import PostgreDataProvider
from .rest_data_provider import RestDataProvider
from .shp_data_provider import ShapeDataProvider
from .sqlite_data_provider import SqliteDataProvider
from .svg_data_provider import SvgDataProvider
from .tab_data_provider import TabDataProvider
from .tms_data_provider import TmsDataProvider
from .wms_data_provider import WmsDataProvider
from .wmts_data_provider import WmtsDataProvider
from _typeshed import Incomplete
from axipy.da import DataObject, Table
from typing import List, Tuple, Union

class ProviderManager:
    class _ShadowDesc:
        def __init__(self) -> None: ...
        def __get__(self, obj, objtype: Incomplete | None = ...): ...
    @property
    def svg(self) -> SvgDataProvider: ...
    @property
    def tab(self) -> TabDataProvider: ...
    @property
    def shp(self) -> ShapeDataProvider: ...
    @property
    def csv(self) -> CsvDataProvider: ...
    @property
    def mif(self) -> MifMidDataProvider: ...
    @property
    def excel(self) -> ExcelDataProvider: ...
    @property
    def sqlite(self) -> SqliteDataProvider: ...
    @property
    def postgre(self) -> PostgreDataProvider: ...
    @property
    def mssql(self) -> MsSqlDataProvider: ...
    @property
    def oracle(self) -> OracleDataProvider: ...
    @property
    def rest(self) -> RestDataProvider: ...
    @property
    def gdal(self) -> GdalDataProvider: ...
    @property
    def tms(self) -> TmsDataProvider: ...
    @property
    def wms(self) -> WmsDataProvider: ...
    @property
    def wmts(self) -> WmtsDataProvider: ...
    @property
    def ogr(self) -> OgrDataProvider: ...
    def find_by_extension(self, file_extension: str) -> DataProvider: ...
    def openfile(self, filepath: str, *args, **kwargs) -> DataObject: ...
    def open(self, definition: dict) -> DataObject: ...
    def open_hidden(self, definition: dict) -> DataObject: ...
    def createfile(self, filepath: str, schema, *args, **kwargs) -> DataObject: ...
    def create(self, definition: dict) -> DataObject: ...
    def create_open(self, definition: dict) -> DataObject: ...
    def loaded_providers(self) -> dict: ...
    def providers(self) -> List[DataProvider]: ...
    def query(self, query_text: str, *tables) -> Table: ...
    def check_query(self, query_text: str, *tables) -> Tuple[bool, str]: ...
    def read_contents(self, definition: Union[dict, str]) -> List[str]: ...

provider_manager: Incomplete
