from PySide2.QtCore import Signal
from _typeshed import Incomplete
from axipy._internal._metaclass import _MappingMetaDocumentation, _MappingMetaExtended
from axipy._internal._utils import _NoInit
from typing import Any, List, Optional, Tuple

class Observer(_NoInit):
    @property
    def value(self) -> Any: ...
    @value.setter
    def value(self, value: Any): ...
    @property
    def name(self) -> str: ...
    @property
    def changed(self) -> Signal: ...

class _CustomMappingMetaExtended(_MappingMetaExtended):
    class _ShadowDesc:
        def __init__(self) -> None: ...
        def __get__(self, obj, objtype: Incomplete | None = ...): ...
    def __iter__(cls): ...
    def __len__(cls) -> int: ...
    def __getitem__(cls, key): ...

class ObserverManager(_MappingMetaDocumentation, metaclass=_CustomMappingMetaExtended):
    class _ShadowDesc:
        def __init__(self) -> None: ...
        def __get__(self, obj, objtype: Incomplete | None = ...): ...
    class _Desc:
        def __set_name__(self, owner, name: str): ...
        def __get__(self, obj, obj_name): ...
        def __set__(self, instance, value) -> None: ...
    Selection: Observer
    Editable: Observer
    SelectionEditable: Observer
    SelectionEditableIsSame: Observer
    ActiveView: Observer
    ActiveMapView: Observer
    ActiveTableView: Observer
    HasTables: Observer
    @classmethod
    def items(cls) -> List[Tuple[str, Observer]]: ...
    @classmethod
    def keys(cls) -> List[str]: ...
    @classmethod
    def values(cls) -> List[Observer]: ...
    @classmethod
    def get(cls, key: str, default_value: Any = ...) -> Optional[Observer]: ...
    @classmethod
    def remove(cls, name: str) -> None: ...
    @classmethod
    def create(cls, name: str, init_value: Any) -> Observer: ...
