from .geometry import Geometry
from .style import Style
from axipy.cpp_core_dp import ShadowFeatureIterator as _ShadowFeatureIterator
from typing import Any, List, Optional, Union

GEOMETRY_ATTR: str
STYLE_ATTR: str

class Feature:
    def __init__(self, properties: dict = ..., geometry: Geometry = ..., style: Style = ..., id: int = ..., **kwargs) -> None: ...
    @property
    def id(self) -> int: ...
    @id.setter
    def id(self, value: int): ...
    def __getitem__(self, index: Union[int, str]) -> Any: ...
    def __setitem__(self, index: Union[int, str], value: Any): ...
    def get(self, key: str, default: Any = ...): ...
    @property
    def geometry(self) -> Optional[Geometry]: ...
    @geometry.setter
    def geometry(self, value: Optional[Geometry]): ...
    def has_geometry(self) -> bool: ...
    @property
    def style(self) -> Optional[Style]: ...
    @style.setter
    def style(self, value: Optional[Style]): ...
    def has_style(self) -> bool: ...
    def __contains__(self, key: Union[int, str]): ...
    def __len__(self) -> int: ...
    def to_geojson(self) -> dict: ...
    def keys(self) -> List[str]: ...
    def values(self) -> List: ...
    def items(self) -> List[tuple]: ...
    def __eq__(self, other: Feature) -> bool: ...

class _FeatureIterator:
    def __init__(self, shadow: _ShadowFeatureIterator) -> None: ...
    def __iter__(self): ...
    def __next__(self) -> Feature: ...
