import typing
from .feature import Feature
from .geometry import Geometry
from .raster import GCP
from .schema import Schema
from PySide2.QtCore import QRectF, QSize, Signal
from PySide2.QtGui import QTransform
from axipy.cs import CoordSystem
from axipy.utl import Rect
from enum import IntFlag
from typing import Iterable, Iterator, List, Union

class NotRegistered(RuntimeError): ...
class NoCoordSystem(RuntimeError): ...

class DataObject:
    def __init__(self) -> None: ...
    @property
    def name(self) -> str: ...
    @name.setter
    def name(self, name: str): ...
    @property
    def provider(self) -> str: ...
    def __eq__(self, other) -> bool: ...
    def close(self) -> None: ...
    def __enter__(self): ...
    def __exit__(self, exception_type, exception_value, traceback) -> None: ...
    @property
    def is_spatial(self) -> bool: ...
    @property
    def properties(self) -> dict: ...
    @property
    def destroyed(self) -> Signal: ...

class SupportedOperations(IntFlag):
    Empty: int
    Insert: int
    Update: int
    Delete: int
    Write: int
    Read: int
    ReadWrite: int

class Table(DataObject):
    @property
    def data_changed(self) -> Signal: ...
    @property
    def schema_changed(self) -> Signal: ...
    @property
    def is_editable(self) -> bool: ...
    @property
    def is_temporary(self) -> bool: ...
    @property
    def is_modified(self) -> bool: ...
    @property
    def supported_operations(self) -> SupportedOperations: ...
    @property
    def schema(self) -> Schema: ...
    @schema.setter
    def schema(self, new_schema: Schema): ...
    @property
    def coordsystem(self) -> typing.Union[CoordSystem, None]: ...
    def ensure_editable(self) -> None: ...
    def insert(self, features: Union[Feature, Iterable[Feature]]): ...
    def update(self, features: Union[Feature, Iterable[Feature]]): ...
    def remove(self, ids: Union[int, Iterator[int]]): ...
    def commit(self) -> None: ...
    def restore(self): ...
    def rollback(self) -> None: ...
    @property
    def can_undo(self) -> bool: ...
    def undo(self) -> None: ...
    @property
    def can_redo(self) -> bool: ...
    def redo(self) -> None: ...
    def itemsInRect(self, bbox: Union[Rect, QRectF, tuple]) -> Iterator[Feature]: ...
    def itemsInObject(self, obj: Geometry) -> Iterator[Feature]: ...
    def itemsByIds(self, ids: List[int]) -> Iterator[Feature]: ...
    def items(self, bbox: Union[Rect, QRectF, tuple] = ..., ids: List[int] = ...) -> Iterator[Feature]: ...
    def count(self, bbox: typing.Union[Rect, QRectF, tuple] = ...) -> int: ...
    def get_bounds(self) -> Rect: ...
    def __len__(self) -> int: ...
    def __iter__(self): ...
    def __exit__(self, exception_type, exception_value, traceback) -> None: ...

class SelectionTable(Table):
    @property
    def base_table(self) -> Table: ...

class QueryTable(Table):
    @property
    def sql_text(self) -> str: ...

class CosmeticTable(Table): ...

class Raster(DataObject):
    @property
    def coordsystem(self) -> typing.Union[CoordSystem, None]: ...
    @property
    def size(self) -> QSize: ...
    @property
    def device_to_scene_transform(self) -> QTransform: ...
    @property
    def scene_to_device_transform(self) -> QTransform: ...
    def get_gcps(self) -> List[GCP]: ...
