from .data_object import DataObject, SelectionTable, Table
from .sqldialect import TypeSqlDialect
from PySide2.QtCore import Signal
from _typeshed import Incomplete
from axipy._internal._utils import _NoInit
from typing import List, Optional, Tuple, Union

class DataManager(_NoInit):
    class _ShadowDesc:
        def __init__(self) -> None: ...
        def __get__(self, obj, objtype: Incomplete | None = ...): ...
    @property
    def updated(self) -> Signal: ...
    @property
    def added(self) -> Signal: ...
    @property
    def removed(self) -> Signal: ...
    @property
    def count(self) -> int: ...
    def __len__(self) -> int: ...
    def __iter__(self): ...
    def __contains__(self, name: str) -> bool: ...
    def __getitem__(self, key: str) -> DataObject: ...
    def add(self, data_object: DataObject): ...
    def remove(self, data_object: DataObject): ...
    def remove_all(self) -> None: ...
    def find(self, name: str) -> Optional[DataObject]: ...
    def exists(self, obj: DataObject) -> bool: ...
    @property
    def objects(self) -> List[DataObject]: ...
    @property
    def all_objects(self) -> List[DataObject]: ...
    @property
    def tables(self) -> List[Table]: ...
    def check_query(self, query_text: str, dialect: Union[TypeSqlDialect, str] = ...) -> Tuple[bool, str]: ...
    def query(self, query_text: str, dialect: Union[TypeSqlDialect, str] = ...) -> Optional[Table]: ...
    def query_hidden(self, query_text: str, dialect: Union[TypeSqlDialect, str] = ...) -> Optional[Table]: ...
    @property
    def selection(self) -> Optional[SelectionTable]: ...
    @property
    def sql_dialect(self) -> TypeSqlDialect: ...

data_manager: Incomplete
