from .interface import AxiomaInterface
from PySide2.QtGui import QIcon
from axipy.da import Observer
from axipy.gui import MapTool
from axipy.menubar import ActionButton, Position, Separator, SystemActionButton, ToolButton
from typing import Any, Callable, Iterable, Union

def tr(text: str): ...
def local_file(*paths: Iterable[str]) -> str: ...

class AxiomaPlugin(AxiomaInterface):
    def load(self) -> None: ...
    def load_mainwindow(self) -> None: ...
    def unload(self) -> None: ...
    def create_tool(self, title: str, on_click: Callable[[], MapTool], icon: Union[str, QIcon] = ..., enable_on: Union[str, Observer] = ..., tooltip: str = ..., doc_file: str = ...) -> ToolButton: ...
    def create_separator(self) -> Separator: ...
    def create_action(self, title: str, on_click: Callable[[], Any], icon: Union[str, QIcon] = ..., enable_on: Observer = ..., tooltip: str = ..., doc_file: str = ...) -> ActionButton: ...
    def create_system_action(self, id: str) -> SystemActionButton: ...
    def get_position(self, tab: str, group: str) -> Position: ...
    def user_plugin_data_dir(self, file_name: str = ...) -> str: ...
    def user_plugin_dir(self, file_name: str = ...) -> str: ...
