from axipy import Position, Plugin

from .my_tool import MyTool


class ExampleTool(Plugin):
    def __init__(self) -> None:
        # Если нет необходимости передавать в конструктор MyTool параметры,
        # можно просто указать имя класса: on_click=MyTool
        self._tool = self.create_tool(
            title="Пример инструмента",
            icon="://icons/share/32px/run3.png",
            on_click=lambda: MyTool("Выберите номер атрибута:")
        )

        position = Position("Примеры модулей", "Инструмент")
        position.add(self._tool)
        self._tool.action.setToolTip("Щелкните мышью на интересующем объекте.\nПравая кнопка мыши - выбор атрибута.")

    def unload(self) -> None:
        self._tool.remove()
