import os
from PyQt5.QtWidgets import QDialog
from PyQt5.QtCore import Qt
from PyQt5.uic import loadUi

class DoubleProgressWidget(QDialog):

    def __init__(self,  parent=None):
        super().__init__(parent)
        cwd = os.path.dirname(__file__)
        self.__ui = loadUi(os.path.join(cwd, "DoubleProgressWidget.ui"), self)
        self.setWindowModality(Qt.WindowModal)
        self.setAttribute(Qt.WA_DeleteOnClose)

    def setCurrentValueForTotalProgress(self, value):
      self.__ui.progressTotal.setValue(value)

    def setMaximumValueForTotalProgress(self, value):
      self.__ui.progressTotal.setMaximum(value)

    def setCurrentTableName(self, name):
      self.__ui.lblTableName.setText(name)

    def setCurrentValueForCurrentProgress(self, value):
      self.__ui.progressCurrent.setValue(value)

    def setMaximumValueForCurrentProgress(self, value):
      self.__ui.progressCurrent.setMaximum(value)
