class _Desc:
    """
    Шаблон дескриптора.
    """
    def __init__(self):
        self._inst = None

    def __set_name__(self, owner, name):
        self._name = name

    def __get__(self, obj, objtype=None):
        if self._inst is not None:
            return self._inst


class _ReadOnlyMeta(type):

    def __setattr__(cls, key, value):
        raise TypeError("Class is read-only")


class _NoInit:

    def __init__(self):
        raise TypeError("Class doesn't support init")


class _NoInitReadOnlyMeta(_NoInit, metaclass=_ReadOnlyMeta):
    ...
