from typing import Optional

import axipy.cpp_app
import axipy.cpp_core_core
import axipy.cpp_cs
import axipy.cpp_gui
import axipy.cpp_render


class _SetWrapAttrMeta(type):

    def __setattr__(cls, key, value):
        if key not in cls.__dict__:
            raise TypeError("Can't create new attributes")
        value = _ShadowManager.Desc(value)
        super().__setattr__(key, value)


class _ShadowManager(metaclass=_SetWrapAttrMeta):
    class Desc:

        def __init__(self, value=None):
            self._value = value

        def __set_name__(self, owner, name):
            self._name = name

        def __get__(self, obj, objtype=None):
            if self._value is None:
                if self._name == "main_window":
                    error_msg = "main_window instance hasn't created yet."
                else:
                    error_msg = "axipy is not initialized"
                raise RuntimeError(error_msg)
            else:
                return self._value

    cs_factory: Optional[axipy.cpp_cs.ShadowCoordSysFactory] = Desc()
    core: Optional[axipy.cpp_core_core.Core] = Desc()
    render: Optional[axipy.cpp_render.Render] = Desc()
    gui: Optional[axipy.cpp_gui.ShadowGui] = Desc()
    state_observer: Optional[axipy.cpp_core_core.StateObserver] = Desc()

    main_window: Optional[axipy.cpp_app.ShadowMainWindow] = Desc()

    @classmethod
    def ensure_axioma_is_initialized(cls):
        getattr(cls, "cs_factory")
        getattr(cls, "core")
        getattr(cls, "render")
        getattr(cls, "gui")
        getattr(cls, "state_observer")

