from typing import overload
import PySide2.QtCore
import PySide2.QtNetwork
import shiboken2
import typing
T = typing.TypeVar('T')

class QWebEngineCookieStore(PySide2.QtCore.QObject):
    cookieAdded: typing.ClassVar[PySide2.QtCore.Signal] = ...
    cookieRemoved: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def deleteAllCookies(self) -> None: ...
    def deleteCookie(self, cookie: PySide2.QtNetwork.QNetworkCookie, origin: PySide2.QtCore.QUrl = ...) -> None: ...
    def deleteSessionCookies(self) -> None: ...
    def loadAllCookies(self) -> None: ...
    def setCookie(self, cookie: PySide2.QtNetwork.QNetworkCookie, origin: PySide2.QtCore.QUrl = ...) -> None: ...

class QWebEngineHttpRequest(shiboken2.Object):
    class Method:
        Get: typing.ClassVar[QWebEngineHttpRequest.Method] = ...
        Post: typing.ClassVar[QWebEngineHttpRequest.Method] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWebEngineHttpRequest.Method: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEngineHttpRequest.Method: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWebEngineHttpRequest.Method: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEngineHttpRequest.Method: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWebEngineHttpRequest.Method: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEngineHttpRequest.Method: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWebEngineHttpRequest.Method: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEngineHttpRequest.Method: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWebEngineHttpRequest.Method: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEngineHttpRequest.Method: ...
        def __sub__(self, other: typing.SupportsInt) -> QWebEngineHttpRequest.Method: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEngineHttpRequest.Method: ...
    Get: typing.ClassVar[QWebEngineHttpRequest.Method] = ...
    Post: typing.ClassVar[QWebEngineHttpRequest.Method] = ...
    @overload
    def __init__(self, url: PySide2.QtCore.QUrl = ..., method: QWebEngineHttpRequest.Method = ...) -> None: ...
    @overload
    def __init__(self, other: QWebEngineHttpRequest) -> None: ...
    def hasHeader(self, headerName: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> bool: ...
    def header(self, headerName: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> PySide2.QtCore.QByteArray: ...
    def headers(self) -> typing.List[PySide2.QtCore.QByteArray]: ...
    def method(self) -> QWebEngineHttpRequest.Method: ...
    def postData(self) -> PySide2.QtCore.QByteArray: ...
    @classmethod
    def postRequest(cls, url: PySide2.QtCore.QUrl, postData: typing.Dict[str,str]) -> QWebEngineHttpRequest: ...
    def setHeader(self, headerName: typing.Union[PySide2.QtCore.QByteArray,bytes], value: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> None: ...
    def setMethod(self, method: QWebEngineHttpRequest.Method) -> None: ...
    def setPostData(self, postData: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> None: ...
    def setUrl(self, url: PySide2.QtCore.QUrl) -> None: ...
    def swap(self, other: QWebEngineHttpRequest) -> None: ...
    def unsetHeader(self, headerName: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> None: ...
    def url(self) -> PySide2.QtCore.QUrl: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QWebEngineUrlRequestInfo(shiboken2.Object):
    class NavigationType:
        NavigationTypeBackForward: typing.ClassVar[QWebEngineUrlRequestInfo.NavigationType] = ...
        NavigationTypeFormSubmitted: typing.ClassVar[QWebEngineUrlRequestInfo.NavigationType] = ...
        NavigationTypeLink: typing.ClassVar[QWebEngineUrlRequestInfo.NavigationType] = ...
        NavigationTypeOther: typing.ClassVar[QWebEngineUrlRequestInfo.NavigationType] = ...
        NavigationTypeRedirect: typing.ClassVar[QWebEngineUrlRequestInfo.NavigationType] = ...
        NavigationTypeReload: typing.ClassVar[QWebEngineUrlRequestInfo.NavigationType] = ...
        NavigationTypeTyped: typing.ClassVar[QWebEngineUrlRequestInfo.NavigationType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestInfo.NavigationType: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestInfo.NavigationType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestInfo.NavigationType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestInfo.NavigationType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestInfo.NavigationType: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestInfo.NavigationType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestInfo.NavigationType: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestInfo.NavigationType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestInfo.NavigationType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestInfo.NavigationType: ...
        def __sub__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestInfo.NavigationType: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestInfo.NavigationType: ...

    class ResourceType:
        ResourceTypeCspReport: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
        ResourceTypeFavicon: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
        ResourceTypeFontResource: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
        ResourceTypeImage: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
        ResourceTypeLast: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
        ResourceTypeMainFrame: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
        ResourceTypeMedia: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
        ResourceTypeNavigationPreloadMainFrame: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
        ResourceTypeNavigationPreloadSubFrame: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
        ResourceTypeObject: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
        ResourceTypePing: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
        ResourceTypePluginResource: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
        ResourceTypePrefetch: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
        ResourceTypeScript: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
        ResourceTypeServiceWorker: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
        ResourceTypeSharedWorker: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
        ResourceTypeStylesheet: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
        ResourceTypeSubFrame: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
        ResourceTypeSubResource: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
        ResourceTypeUnknown: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
        ResourceTypeWorker: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
        ResourceTypeXhr: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestInfo.ResourceType: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestInfo.ResourceType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestInfo.ResourceType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestInfo.ResourceType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestInfo.ResourceType: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestInfo.ResourceType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestInfo.ResourceType: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestInfo.ResourceType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestInfo.ResourceType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestInfo.ResourceType: ...
        def __sub__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestInfo.ResourceType: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestInfo.ResourceType: ...
    NavigationTypeBackForward: typing.ClassVar[QWebEngineUrlRequestInfo.NavigationType] = ...
    NavigationTypeFormSubmitted: typing.ClassVar[QWebEngineUrlRequestInfo.NavigationType] = ...
    NavigationTypeLink: typing.ClassVar[QWebEngineUrlRequestInfo.NavigationType] = ...
    NavigationTypeOther: typing.ClassVar[QWebEngineUrlRequestInfo.NavigationType] = ...
    NavigationTypeRedirect: typing.ClassVar[QWebEngineUrlRequestInfo.NavigationType] = ...
    NavigationTypeReload: typing.ClassVar[QWebEngineUrlRequestInfo.NavigationType] = ...
    NavigationTypeTyped: typing.ClassVar[QWebEngineUrlRequestInfo.NavigationType] = ...
    ResourceTypeCspReport: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
    ResourceTypeFavicon: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
    ResourceTypeFontResource: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
    ResourceTypeImage: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
    ResourceTypeLast: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
    ResourceTypeMainFrame: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
    ResourceTypeMedia: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
    ResourceTypeNavigationPreloadMainFrame: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
    ResourceTypeNavigationPreloadSubFrame: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
    ResourceTypeObject: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
    ResourceTypePing: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
    ResourceTypePluginResource: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
    ResourceTypePrefetch: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
    ResourceTypeScript: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
    ResourceTypeServiceWorker: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
    ResourceTypeSharedWorker: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
    ResourceTypeStylesheet: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
    ResourceTypeSubFrame: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
    ResourceTypeSubResource: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
    ResourceTypeUnknown: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
    ResourceTypeWorker: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
    ResourceTypeXhr: typing.ClassVar[QWebEngineUrlRequestInfo.ResourceType] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def block(self, shouldBlock: bool) -> None: ...
    def changed(self) -> bool: ...
    def firstPartyUrl(self) -> PySide2.QtCore.QUrl: ...
    def initiator(self) -> PySide2.QtCore.QUrl: ...
    def navigationType(self) -> QWebEngineUrlRequestInfo.NavigationType: ...
    def redirect(self, url: PySide2.QtCore.QUrl) -> None: ...
    def requestMethod(self) -> PySide2.QtCore.QByteArray: ...
    def requestUrl(self) -> PySide2.QtCore.QUrl: ...
    def resourceType(self) -> QWebEngineUrlRequestInfo.ResourceType: ...
    def setHttpHeader(self, name: typing.Union[PySide2.QtCore.QByteArray,bytes], value: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> None: ...

class QWebEngineUrlRequestInterceptor(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, p: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def interceptRequest(self, info: QWebEngineUrlRequestInfo) -> None: ...

class QWebEngineUrlRequestJob(PySide2.QtCore.QObject):
    class Error:
        NoError: typing.ClassVar[QWebEngineUrlRequestJob.Error] = ...
        RequestAborted: typing.ClassVar[QWebEngineUrlRequestJob.Error] = ...
        RequestDenied: typing.ClassVar[QWebEngineUrlRequestJob.Error] = ...
        RequestFailed: typing.ClassVar[QWebEngineUrlRequestJob.Error] = ...
        UrlInvalid: typing.ClassVar[QWebEngineUrlRequestJob.Error] = ...
        UrlNotFound: typing.ClassVar[QWebEngineUrlRequestJob.Error] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestJob.Error: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestJob.Error: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestJob.Error: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestJob.Error: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestJob.Error: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestJob.Error: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestJob.Error: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestJob.Error: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestJob.Error: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestJob.Error: ...
        def __sub__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestJob.Error: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEngineUrlRequestJob.Error: ...
    NoError: typing.ClassVar[QWebEngineUrlRequestJob.Error] = ...
    RequestAborted: typing.ClassVar[QWebEngineUrlRequestJob.Error] = ...
    RequestDenied: typing.ClassVar[QWebEngineUrlRequestJob.Error] = ...
    RequestFailed: typing.ClassVar[QWebEngineUrlRequestJob.Error] = ...
    UrlInvalid: typing.ClassVar[QWebEngineUrlRequestJob.Error] = ...
    UrlNotFound: typing.ClassVar[QWebEngineUrlRequestJob.Error] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def fail(self, error: QWebEngineUrlRequestJob.Error) -> None: ...
    def initiator(self) -> PySide2.QtCore.QUrl: ...
    def redirect(self, url: PySide2.QtCore.QUrl) -> None: ...
    def reply(self, contentType: typing.Union[PySide2.QtCore.QByteArray,bytes], device: PySide2.QtCore.QIODevice) -> None: ...
    def requestHeaders(self) -> typing.Dict[PySide2.QtCore.QByteArray,PySide2.QtCore.QByteArray]: ...
    def requestMethod(self) -> PySide2.QtCore.QByteArray: ...
    def requestUrl(self) -> PySide2.QtCore.QUrl: ...

class QWebEngineUrlScheme(shiboken2.Object):
    class Flag:
        ContentSecurityPolicyIgnored: typing.ClassVar[QWebEngineUrlScheme.Flag] = ...
        CorsEnabled: typing.ClassVar[QWebEngineUrlScheme.Flag] = ...
        LocalAccessAllowed: typing.ClassVar[QWebEngineUrlScheme.Flag] = ...
        LocalScheme: typing.ClassVar[QWebEngineUrlScheme.Flag] = ...
        NoAccessAllowed: typing.ClassVar[QWebEngineUrlScheme.Flag] = ...
        SecureScheme: typing.ClassVar[QWebEngineUrlScheme.Flag] = ...
        ServiceWorkersAllowed: typing.ClassVar[QWebEngineUrlScheme.Flag] = ...
        ViewSourceAllowed: typing.ClassVar[QWebEngineUrlScheme.Flag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.Flags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QWebEngineUrlScheme.Flags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.Flags: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.Flags: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.Flags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.Flags: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.Flags: ...

    class Flags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.Flags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QWebEngineUrlScheme.Flags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.Flags: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.Flags: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.Flags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.Flags: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.Flags: ...

    class SpecialPort:
        PortUnspecified: typing.ClassVar[QWebEngineUrlScheme.SpecialPort] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.SpecialPort: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.SpecialPort: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.SpecialPort: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.SpecialPort: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.SpecialPort: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.SpecialPort: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.SpecialPort: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.SpecialPort: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.SpecialPort: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.SpecialPort: ...
        def __sub__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.SpecialPort: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.SpecialPort: ...

    class Syntax:
        Host: typing.ClassVar[QWebEngineUrlScheme.Syntax] = ...
        HostAndPort: typing.ClassVar[QWebEngineUrlScheme.Syntax] = ...
        HostPortAndUserInformation: typing.ClassVar[QWebEngineUrlScheme.Syntax] = ...
        Path: typing.ClassVar[QWebEngineUrlScheme.Syntax] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.Syntax: ...
        def __and__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.Syntax: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.Syntax: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.Syntax: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.Syntax: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.Syntax: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.Syntax: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.Syntax: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.Syntax: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.Syntax: ...
        def __sub__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.Syntax: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebEngineUrlScheme.Syntax: ...
    ContentSecurityPolicyIgnored: typing.ClassVar[QWebEngineUrlScheme.Flag] = ...
    CorsEnabled: typing.ClassVar[QWebEngineUrlScheme.Flag] = ...
    LocalAccessAllowed: typing.ClassVar[QWebEngineUrlScheme.Flag] = ...
    LocalScheme: typing.ClassVar[QWebEngineUrlScheme.Flag] = ...
    NoAccessAllowed: typing.ClassVar[QWebEngineUrlScheme.Flag] = ...
    PortUnspecified: typing.ClassVar[QWebEngineUrlScheme.SpecialPort] = ...
    SecureScheme: typing.ClassVar[QWebEngineUrlScheme.Flag] = ...
    ServiceWorkersAllowed: typing.ClassVar[QWebEngineUrlScheme.Flag] = ...
    ViewSourceAllowed: typing.ClassVar[QWebEngineUrlScheme.Flag] = ...
    @overload
    def __init__(self, name: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> None: ...
    @overload
    def __init__(self, that: QWebEngineUrlScheme) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def defaultPort(self) -> int: ...
    def flags(self) -> typing.Union[QWebEngineUrlScheme.Flags,QWebEngineUrlScheme.Flag]: ...
    def name(self) -> PySide2.QtCore.QByteArray: ...
    @classmethod
    def registerScheme(cls, scheme: QWebEngineUrlScheme) -> None: ...
    @classmethod
    def schemeByName(cls, name: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> QWebEngineUrlScheme: ...
    def setDefaultPort(self, newValue: int) -> None: ...
    def setFlags(self, newValue: typing.Union[QWebEngineUrlScheme.Flags,QWebEngineUrlScheme.Flag]) -> None: ...
    def setName(self, newValue: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> None: ...
    def setSyntax(self, newValue: QWebEngineUrlScheme.Syntax) -> None: ...
    def syntax(self) -> QWebEngineUrlScheme.Syntax: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QWebEngineUrlSchemeHandler(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def requestStarted(self, arg__1: QWebEngineUrlRequestJob) -> None: ...
