from PySide2.QtGui import QTransform
from _typeshed import Incomplete
from axipy.cpp_core_geometry import ShadowPolygon, Type as GeometryType
from axipy.cs import AreaUnit, CoordSystem, LinearUnit
from axipy.utl import Pnt, Rect
from typing import Iterable, List, Optional, Tuple, Union

Type = GeometryType

class Geometry:
    def __init__(self) -> None: ...
    def get_length(self, u: LinearUnit = ...) -> float: ...
    def get_perimeter(self, u: LinearUnit = ...) -> float: ...
    def get_area(self, area_unit: AreaUnit = ...) -> float: ...
    @property
    def bounds(self) -> Rect: ...
    @property
    def type(self) -> GeometryType: ...
    @property
    def name(self) -> str: ...
    def get_distance(self, other: Geometry, u: LinearUnit = ...) -> float: ...
    @staticmethod
    def from_wkt(wkt: str, coordsystem: CoordSystem = ...) -> Geometry: ...
    @property
    def wkt(self) -> str: ...
    def to_wkt(self) -> str: ...
    @staticmethod
    def from_wkb(wkb: bytes, coordsystem: CoordSystem = ...) -> Geometry: ...
    @property
    def wkb(self) -> bytes: ...
    def to_wkb(self) -> bytes: ...
    @property
    def coordsystem(self) -> CoordSystem: ...
    @coordsystem.setter
    def coordsystem(self, cs: CoordSystem): ...
    def equals(self, other: Geometry) -> bool: ...
    def __eq__(self, other) -> bool: ...
    def almost_equals(self, other: Geometry, tolerance: float) -> bool: ...
    def contains(self, other: Geometry) -> bool: ...
    def crosses(self, other: Geometry) -> bool: ...
    def disjoint(self, other: Geometry) -> bool: ...
    def intersects(self, other: Geometry) -> bool: ...
    def overlaps(self, other: Geometry) -> bool: ...
    def touches(self, other: Geometry) -> bool: ...
    def within(self, other: Geometry) -> bool: ...
    def covers(self, other: Geometry) -> bool: ...
    def relate(self, other: Geometry) -> str: ...
    def boundary(self) -> Geometry: ...
    def centroid(self) -> Geometry: ...
    def difference(self, other: Geometry) -> Geometry: ...
    def intersection(self, other: Geometry) -> Geometry: ...
    def symmetric_difference(self, other: Geometry) -> Geometry: ...
    def union(self, other: Geometry) -> Geometry: ...
    def buffer(self, distance: float, resolution: int = ..., capStyle: int = ..., joinStyle: int = ..., mitreLimit: float = ...) -> Geometry: ...
    def convex_hull(self) -> Geometry: ...
    def envelope(self) -> Geometry: ...
    def affine_transform(self, trans: QTransform) -> Geometry: ...
    def shift(self, dx: float, dy: float) -> Geometry: ...
    def scale(self, kx: float, ky: float) -> Geometry: ...
    def reproject(self, cs: CoordSystem) -> Geometry: ...
    def rotate(self, point: Union[Pnt, Tuple[float, float]], angle: float) -> Geometry: ...
    @property
    def is_valid(self) -> bool: ...
    @property
    def is_valid_reason(self) -> str: ...
    def normalize(self) -> Geometry: ...
    def clone(self) -> Geometry: ...
    @staticmethod
    def point_by_azimuth(point: Union[Pnt, Tuple[float, float]], azimuth: float, distance: float, cs: CoordSystem = ...) -> Pnt: ...
    @staticmethod
    def distance_by_points(start: Union[Pnt, Tuple[float, float]], end: Union[Pnt, Tuple[float, float]], cs: CoordSystem = ...) -> Tuple: ...
    def to_linestring(self) -> Optional['Geometry']: ...
    def to_polygon(self) -> Optional['Geometry']: ...
    def to_geojson(self) -> str: ...
    @staticmethod
    def from_geojson(json: str, cs: Optional[CoordSystem] = ...) -> Geometry: ...
    def to_mif(self) -> str: ...
    @staticmethod
    def from_mif(mif: str) -> Geometry: ...

class Point(Geometry):
    def __init__(self, x: float, y: float, cs: CoordSystem = ...) -> None: ...
    @property
    def x(self) -> float: ...
    @x.setter
    def x(self, _x) -> None: ...
    @property
    def y(self) -> float: ...
    @y.setter
    def y(self, _y) -> None: ...
    def __eq__(self, other) -> bool: ...

class Line(Geometry):
    def __init__(self, begin: Pnt, end: Pnt, cs: CoordSystem = ...) -> None: ...
    @property
    def begin(self) -> Pnt: ...
    @begin.setter
    def begin(self, p) -> None: ...
    @property
    def end(self) -> Pnt: ...
    @end.setter
    def end(self, p) -> None: ...

class ListPoint:
    m: Incomplete
    def __init__(self, ls) -> None: ...
    def __len__(self) -> int: ...
    def __getitem__(self, idx): ...
    def __setitem__(self, idx, p) -> None: ...
    def insert(self, idx, p) -> None: ...
    def append(self, p) -> None: ...
    def remove(self, idx) -> None: ...
    def pop(self, idx) -> None: ...

class LineString(Geometry):
    def __init__(self, *points: Union[Pnt, Tuple[float, float], Iterable[Pnt], Iterable[Tuple[float, float]]], cs: CoordSystem = ...) -> None: ...
    @property
    def points(self) -> List[Pnt]: ...
    def __len__(self) -> int: ...

class ListHoles:
    m: Incomplete
    def __init__(self, poly: ShadowPolygon) -> None: ...
    def __len__(self) -> int: ...
    def __getitem__(self, idx): ...
    def append(self, *points: Union[Pnt, Tuple[float, float], Iterable[Pnt], Iterable[Tuple[float, float]]]): ...
    def remove(self, idx) -> None: ...

class Polygon(Geometry):
    def __init__(self, *points: Union[Pnt, Tuple[float, float], Iterable[Pnt], Iterable[Tuple[float, float]]], cs: CoordSystem = ...) -> None: ...
    @staticmethod
    def from_rect(rect: Rect, cs: CoordSystem = ...) -> Polygon: ...
    @property
    def points(self) -> List[Pnt]: ...
    @property
    def holes(self) -> List[Pnt]: ...
    def __len__(self) -> int: ...

class GeometryCollection(Geometry):
    def __init__(self, cs: CoordSystem = ...) -> None: ...
    def __len__(self) -> int: ...
    def append(self, *value: Union[Geometry, Pnt, Tuple[float, float]]): ...
    def remove(self, idx: int): ...
    def __getitem__(self, idx) -> Geometry: ...
    def __setitem__(self, idx, *value: Union[Geometry, Pnt, Tuple[float, float]]): ...
    def try_to_simplified(self) -> Union['MultiPoint', 'MultiLineString', 'MultiPolygon', 'GeometryCollection']: ...

class MultiPoint(GeometryCollection):
    def __init__(self, cs: CoordSystem = ...) -> None: ...

class MultiLineString(GeometryCollection):
    def __init__(self, cs: CoordSystem = ...) -> None: ...

class MultiPolygon(GeometryCollection):
    def __init__(self, cs: CoordSystem = ...) -> None: ...
