from enum import Enum

__all__ = ["Notifications"]


class Notifications(int, Enum):
    """Отправление уведомлений в виде всплывающего окна с его последующей регистрацией в окне уведомлений.
    """

    Information = 0
    Warning = 1
    Critical = 2
    Success = 3

    @staticmethod
    def push(title: str, text: str, type_message: int = 0):
        """Отправляет уведомление.

        Args:
            title: Заголовок
            text: Текст сообщения.
            type_message: Тип сообщения. В зависимости от типа сообщения в окне уведомлений оно помечается соответствующим цветом.

        .. csv-table:: Допустимые значения для типа сообщения:
            :header: Атрибут, Наименование

            `Information`, Информационное сообщение. Устанавливается по умолчанию
            `Warning`, Предупреждение
            `Critical`, Критическая ошибка
            `Success`, Успешное выполнение процесса

        Пример::

            from axipy import Notifications
            Notifications.push('Предупреждение', 'Сообщение', Notifications.Warning)
        """
        from axipy.cpp_gui import ShadowNotifications
        return ShadowNotifications.push(title, text, type_message)
