from .view import LegendView, MapView, ReportView, TableView, View
from PySide2.QtCore import QObject, Signal
from PySide2.QtWidgets import QWidget
from _typeshed import Incomplete
from axipy.da import Table
from axipy.render import Map, Report
from typing import List, Optional

class ViewManager:
    class _ViewManagerSignals(QObject):
        mainwindow_activated: Incomplete
    def __init__(self) -> None: ...
    @property
    def mainwindow_activated(self) -> Signal: ...
    @property
    def shadow(self): ...
    @property
    def active_changed(self) -> Signal: ...
    @property
    def count_changed(self) -> Signal: ...
    def activate(self, view: View): ...
    def close(self, view: View): ...
    def close_all(self) -> None: ...
    @property
    def active(self) -> Optional[View]: ...
    @active.setter
    def active(self, view: View): ...
    @property
    def views(self) -> List[View]: ...
    @property
    def mapviews(self) -> List[MapView]: ...
    @property
    def reportviews(self) -> List[ReportView]: ...
    @property
    def tableviews(self) -> List[TableView]: ...
    @property
    def legendviews(self) -> List[LegendView]: ...
    @property
    def count(self) -> int: ...
    def __len__(self) -> int: ...
    def __getitem__(self, key: str) -> View: ...
    def __contains__(self, key: str) -> bool: ...
    def __iter__(self): ...
    def create_mapview(self, map: Map) -> MapView: ...
    def create_tableview(self, table: Table) -> TableView: ...
    def create_reportview(self, report: Report = ...) -> ReportView: ...
    def create_legendview(self, mapview: MapView) -> LegendView: ...
    @property
    def global_parent(self) -> QWidget: ...
    def create_layer_control(self): ...
    def create_data_catalog(self): ...

view_manager: Incomplete
