from PySide2.QtCore import QObject, Signal
from PySide2.QtWidgets import QWidget
from axipy.cpp_gui import AcceptableToolPanelHandler, CustomToolPanelHandler
from axipy.da import Observer

class AxipyActiveToolPanelHandlerBase(QObject):
    def __init__(self, shadow_handler) -> None: ...
    def __del__(self) -> None: ...
    def activate(self) -> None: ...
    def deactivate(self) -> None: ...
    def set_panel_title(self, title: str): ...
    @property
    def widget(self) -> QWidget: ...
    def set_widget(self, widget: QWidget): ...
    def set_observer(self, observer_id: Observer): ...
    @property
    def activated(self) -> Signal: ...
    @property
    def deactivated(self) -> Signal: ...
    @property
    def panel_was_closed(self) -> Signal: ...

class AxipyAcceptableActiveToolHandler(AxipyActiveToolPanelHandlerBase):
    def __init__(self, shadow_handler: AcceptableToolPanelHandler) -> None: ...
    @property
    def accepted(self) -> Signal: ...
    def try_enable(self) -> None: ...
    def disable(self) -> None: ...

class AxipyCustomActiveToolPanelHandler(AxipyActiveToolPanelHandlerBase):
    def __init__(self, shadow_handler: CustomToolPanelHandler) -> None: ...

class ActiveToolPanel(QObject):
    def __init__(self) -> None: ...
    def make_acceptable(self, title: str, observer_id: Observer, widget: QWidget = ...) -> AxipyAcceptableActiveToolHandler: ...
    def make_custom(self, title: str, observer_id: Observer, widget: QWidget = ...) -> AxipyCustomActiveToolPanelHandler: ...
