from axipy import Position, Plugin, Notifications


class ExamplePluginMinimal(Plugin):
    def __init__(self) -> None:
        self.title = self.tr("Минимальный плагин")

        self._action = self.create_action(
            "Пример действия",
            icon="://icons/share/32px/run3.png",
            on_click=self.show_message,
        )
        position = Position("Примеры модулей", "Минимальный")
        position.add(self._action)
        self._action.action.setToolTip("Всплывающая подсказка")

    def unload(self) -> None:
        self._action.remove()

    def show_message(self) -> None:
        Notifications.push(self.title, "Пример выполнения действия по нажатию кнопки")
